/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.slimvalidator.metadata;

import io.github.sashirestela.slimvalidator.ConstraintValidator;
import io.github.sashirestela.slimvalidator.exception.ValidationException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;

public final class ClassMetadata {
    private final String fullName;
    private final List<FieldMetadata> fields;

    ClassMetadata(String fullName, List<FieldMetadata> fields) {
        this.fullName = fullName;
        this.fields = fields;
    }

    public static ClassMetadataBuilder builder() {
        return new ClassMetadataBuilder();
    }

    public String getFullName() {
        return this.fullName;
    }

    public List<FieldMetadata> getFields() {
        return this.fields;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClassMetadata)) {
            return false;
        }
        ClassMetadata other = (ClassMetadata)o;
        String this$fullName = this.getFullName();
        String other$fullName = other.getFullName();
        if (this$fullName == null ? other$fullName != null : !this$fullName.equals(other$fullName)) {
            return false;
        }
        List<FieldMetadata> this$fields = this.getFields();
        List<FieldMetadata> other$fields = other.getFields();
        return !(this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $fullName = this.getFullName();
        result = result * 59 + ($fullName == null ? 43 : $fullName.hashCode());
        List<FieldMetadata> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        return result;
    }

    public String toString() {
        return "ClassMetadata(fullName=" + this.getFullName() + ", fields=" + this.getFields() + ")";
    }

    public static class ClassMetadataBuilder {
        private String fullName;
        private List<FieldMetadata> fields;

        ClassMetadataBuilder() {
        }

        public ClassMetadataBuilder fullName(String fullName) {
            this.fullName = fullName;
            return this;
        }

        public ClassMetadataBuilder fields(List<FieldMetadata> fields) {
            this.fields = fields;
            return this;
        }

        public ClassMetadata build() {
            return new ClassMetadata(this.fullName, this.fields);
        }

        public String toString() {
            return "ClassMetadata.ClassMetadataBuilder(fullName=" + this.fullName + ", fields=" + this.fields + ")";
        }
    }

    public static final class AnnotationMetadata {
        private final Class<? extends ConstraintValidator> validatedBy;
        private final Map<String, Object> valuesByAnnotMethod;
        private final List<AnnotationMetadata> subAnnotations;
        private final Annotation annotation;

        AnnotationMetadata(Class<? extends ConstraintValidator> validatedBy, Map<String, Object> valuesByAnnotMethod, List<AnnotationMetadata> subAnnotations, Annotation annotation) {
            this.validatedBy = validatedBy;
            this.valuesByAnnotMethod = valuesByAnnotMethod;
            this.subAnnotations = subAnnotations;
            this.annotation = annotation;
        }

        public static AnnotationMetadataBuilder builder() {
            return new AnnotationMetadataBuilder();
        }

        public Class<? extends ConstraintValidator> getValidatedBy() {
            return this.validatedBy;
        }

        public Map<String, Object> getValuesByAnnotMethod() {
            return this.valuesByAnnotMethod;
        }

        public List<AnnotationMetadata> getSubAnnotations() {
            return this.subAnnotations;
        }

        public Annotation getAnnotation() {
            return this.annotation;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AnnotationMetadata)) {
                return false;
            }
            AnnotationMetadata other = (AnnotationMetadata)o;
            Class<? extends ConstraintValidator> this$validatedBy = this.getValidatedBy();
            Class<? extends ConstraintValidator> other$validatedBy = other.getValidatedBy();
            if (this$validatedBy == null ? other$validatedBy != null : !this$validatedBy.equals(other$validatedBy)) {
                return false;
            }
            Map<String, Object> this$valuesByAnnotMethod = this.getValuesByAnnotMethod();
            Map<String, Object> other$valuesByAnnotMethod = other.getValuesByAnnotMethod();
            if (this$valuesByAnnotMethod == null ? other$valuesByAnnotMethod != null : !((Object)this$valuesByAnnotMethod).equals(other$valuesByAnnotMethod)) {
                return false;
            }
            List<AnnotationMetadata> this$subAnnotations = this.getSubAnnotations();
            List<AnnotationMetadata> other$subAnnotations = other.getSubAnnotations();
            if (this$subAnnotations == null ? other$subAnnotations != null : !((Object)this$subAnnotations).equals(other$subAnnotations)) {
                return false;
            }
            Annotation this$annotation = this.getAnnotation();
            Annotation other$annotation = other.getAnnotation();
            return !(this$annotation == null ? other$annotation != null : !((Object)this$annotation).equals(other$annotation));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<? extends ConstraintValidator> $validatedBy = this.getValidatedBy();
            result = result * 59 + ($validatedBy == null ? 43 : $validatedBy.hashCode());
            Map<String, Object> $valuesByAnnotMethod = this.getValuesByAnnotMethod();
            result = result * 59 + ($valuesByAnnotMethod == null ? 43 : ((Object)$valuesByAnnotMethod).hashCode());
            List<AnnotationMetadata> $subAnnotations = this.getSubAnnotations();
            result = result * 59 + ($subAnnotations == null ? 43 : ((Object)$subAnnotations).hashCode());
            Annotation $annotation = this.getAnnotation();
            result = result * 59 + ($annotation == null ? 43 : ((Object)$annotation).hashCode());
            return result;
        }

        public String toString() {
            return "ClassMetadata.AnnotationMetadata(validatedBy=" + this.getValidatedBy() + ", valuesByAnnotMethod=" + this.getValuesByAnnotMethod() + ", subAnnotations=" + this.getSubAnnotations() + ", annotation=" + this.getAnnotation() + ")";
        }

        public static class AnnotationMetadataBuilder {
            private Class<? extends ConstraintValidator> validatedBy;
            private Map<String, Object> valuesByAnnotMethod;
            private List<AnnotationMetadata> subAnnotations;
            private Annotation annotation;

            AnnotationMetadataBuilder() {
            }

            public AnnotationMetadataBuilder validatedBy(Class<? extends ConstraintValidator> validatedBy) {
                this.validatedBy = validatedBy;
                return this;
            }

            public AnnotationMetadataBuilder valuesByAnnotMethod(Map<String, Object> valuesByAnnotMethod) {
                this.valuesByAnnotMethod = valuesByAnnotMethod;
                return this;
            }

            public AnnotationMetadataBuilder subAnnotations(List<AnnotationMetadata> subAnnotations) {
                this.subAnnotations = subAnnotations;
                return this;
            }

            public AnnotationMetadataBuilder annotation(Annotation annotation) {
                this.annotation = annotation;
                return this;
            }

            public AnnotationMetadata build() {
                return new AnnotationMetadata(this.validatedBy, this.valuesByAnnotMethod, this.subAnnotations, this.annotation);
            }

            public String toString() {
                return "ClassMetadata.AnnotationMetadata.AnnotationMetadataBuilder(validatedBy=" + this.validatedBy + ", valuesByAnnotMethod=" + this.valuesByAnnotMethod + ", subAnnotations=" + this.subAnnotations + ", annotation=" + this.annotation + ")";
            }
        }
    }

    public static final class FieldMetadata {
        private final String name;
        private final List<AnnotationMetadata> annotations;

        public Object getValue(Object object) {
            Class<?> clazz = object.getClass();
            try {
                Method method = clazz.getDeclaredMethod(this.getMethodName(this.name), null);
                return method.invoke(object, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new ValidationException("Cannot read the field {0}.{1}().", clazz.getSimpleName(), this.name, e);
            }
        }

        private String getMethodName(String name) {
            return "get" + name.substring(0, 1).toUpperCase() + name.substring(1);
        }

        FieldMetadata(String name, List<AnnotationMetadata> annotations) {
            this.name = name;
            this.annotations = annotations;
        }

        public static FieldMetadataBuilder builder() {
            return new FieldMetadataBuilder();
        }

        public String getName() {
            return this.name;
        }

        public List<AnnotationMetadata> getAnnotations() {
            return this.annotations;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FieldMetadata)) {
                return false;
            }
            FieldMetadata other = (FieldMetadata)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            List<AnnotationMetadata> this$annotations = this.getAnnotations();
            List<AnnotationMetadata> other$annotations = other.getAnnotations();
            return !(this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            List<AnnotationMetadata> $annotations = this.getAnnotations();
            result = result * 59 + ($annotations == null ? 43 : ((Object)$annotations).hashCode());
            return result;
        }

        public String toString() {
            return "ClassMetadata.FieldMetadata(name=" + this.getName() + ", annotations=" + this.getAnnotations() + ")";
        }

        public static class FieldMetadataBuilder {
            private String name;
            private List<AnnotationMetadata> annotations;

            FieldMetadataBuilder() {
            }

            public FieldMetadataBuilder name(String name) {
                this.name = name;
                return this;
            }

            public FieldMetadataBuilder annotations(List<AnnotationMetadata> annotations) {
                this.annotations = annotations;
                return this;
            }

            public FieldMetadata build() {
                return new FieldMetadata(this.name, this.annotations);
            }

            public String toString() {
                return "ClassMetadata.FieldMetadata.FieldMetadataBuilder(name=" + this.name + ", annotations=" + this.annotations + ")";
            }
        }
    }
}

