/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.moderation;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import java.util.List;

public class Moderation {
    private String id;
    private String model;
    private List<ModerationResult> results;

    public String getId() {
        return this.id;
    }

    public String getModel() {
        return this.model;
    }

    public List<ModerationResult> getResults() {
        return this.results;
    }

    public String toString() {
        return "Moderation(id=" + this.getId() + ", model=" + this.getModel() + ", results=" + this.getResults() + ")";
    }

    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class ModerationResult {
        private Boolean flagged;
        private Category categories;
        private CategoryScore categoryScores;

        public Boolean getFlagged() {
            return this.flagged;
        }

        public Category getCategories() {
            return this.categories;
        }

        public CategoryScore getCategoryScores() {
            return this.categoryScores;
        }

        public String toString() {
            return "Moderation.ModerationResult(flagged=" + this.getFlagged() + ", categories=" + this.getCategories() + ", categoryScores=" + this.getCategoryScores() + ")";
        }

        public static class CategoryScore {
            private Double sexual;
            private Double hate;
            private Double harassment;
            @JsonProperty(value="self-harm")
            private Double selfHarm;
            @JsonProperty(value="sexual/minors")
            private Double sexualMinors;
            @JsonProperty(value="hate/threatening")
            private Double hateThreatening;
            @JsonProperty(value="violence/graphic")
            private Double violencGraphic;
            @JsonProperty(value="self-harm/intent")
            private Double selfHarmIntent;
            @JsonProperty(value="self-harm/instructions")
            private Double selfHarmInstructions;
            @JsonProperty(value="harassment/threatening")
            private Double harassmentThreatening;
            private Double violence;

            public Double getSexual() {
                return this.sexual;
            }

            public Double getHate() {
                return this.hate;
            }

            public Double getHarassment() {
                return this.harassment;
            }

            public Double getSelfHarm() {
                return this.selfHarm;
            }

            public Double getSexualMinors() {
                return this.sexualMinors;
            }

            public Double getHateThreatening() {
                return this.hateThreatening;
            }

            public Double getViolencGraphic() {
                return this.violencGraphic;
            }

            public Double getSelfHarmIntent() {
                return this.selfHarmIntent;
            }

            public Double getSelfHarmInstructions() {
                return this.selfHarmInstructions;
            }

            public Double getHarassmentThreatening() {
                return this.harassmentThreatening;
            }

            public Double getViolence() {
                return this.violence;
            }

            public String toString() {
                return "Moderation.ModerationResult.CategoryScore(sexual=" + this.getSexual() + ", hate=" + this.getHate() + ", harassment=" + this.getHarassment() + ", selfHarm=" + this.getSelfHarm() + ", sexualMinors=" + this.getSexualMinors() + ", hateThreatening=" + this.getHateThreatening() + ", violencGraphic=" + this.getViolencGraphic() + ", selfHarmIntent=" + this.getSelfHarmIntent() + ", selfHarmInstructions=" + this.getSelfHarmInstructions() + ", harassmentThreatening=" + this.getHarassmentThreatening() + ", violence=" + this.getViolence() + ")";
            }
        }

        public static class Category {
            private Boolean sexual;
            private Boolean hate;
            private Boolean harassment;
            @JsonProperty(value="self-harm")
            private Boolean selfHarm;
            @JsonProperty(value="sexual/minors")
            private Boolean sexualMinors;
            @JsonProperty(value="hate/threatening")
            private Boolean hateThreatening;
            @JsonProperty(value="violence/graphic")
            private Boolean violencGraphic;
            @JsonProperty(value="self-harm/intent")
            private Boolean selfHarmIntent;
            @JsonProperty(value="self-harm/instructions")
            private Boolean selfHarmInstructions;
            @JsonProperty(value="harassment/threatening")
            private Boolean harassmentThreatening;
            private Boolean violence;

            public Boolean getSexual() {
                return this.sexual;
            }

            public Boolean getHate() {
                return this.hate;
            }

            public Boolean getHarassment() {
                return this.harassment;
            }

            public Boolean getSelfHarm() {
                return this.selfHarm;
            }

            public Boolean getSexualMinors() {
                return this.sexualMinors;
            }

            public Boolean getHateThreatening() {
                return this.hateThreatening;
            }

            public Boolean getViolencGraphic() {
                return this.violencGraphic;
            }

            public Boolean getSelfHarmIntent() {
                return this.selfHarmIntent;
            }

            public Boolean getSelfHarmInstructions() {
                return this.selfHarmInstructions;
            }

            public Boolean getHarassmentThreatening() {
                return this.harassmentThreatening;
            }

            public Boolean getViolence() {
                return this.violence;
            }

            public String toString() {
                return "Moderation.ModerationResult.Category(sexual=" + this.getSexual() + ", hate=" + this.getHate() + ", harassment=" + this.getHarassment() + ", selfHarm=" + this.getSelfHarm() + ", sexualMinors=" + this.getSexualMinors() + ", hateThreatening=" + this.getHateThreatening() + ", violencGraphic=" + this.getViolencGraphic() + ", selfHarmIntent=" + this.getSelfHarmIntent() + ", selfHarmInstructions=" + this.getSelfHarmInstructions() + ", harassmentThreatening=" + this.getHarassmentThreatening() + ", violence=" + this.getViolence() + ")";
            }
        }
    }
}

