/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.audio;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.openai.domain.audio.AudioResponseFormat;
import io.github.sashirestela.slimvalidator.constraints.Extension;
import io.github.sashirestela.slimvalidator.constraints.Range;
import io.github.sashirestela.slimvalidator.constraints.Required;
import java.nio.file.Path;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class TranslationRequest {
    @Required
    @Extension(value={"flac", "mp3", "mp4", "mpeg", "mpga", "m4a", "ogg", "wav", "webm"})
    private Path file;
    @Required
    private String model;
    private String prompt;
    private AudioResponseFormat responseFormat;
    @Range(min=0.0, max=1.0)
    private Double temperature;

    TranslationRequest(Path file, String model, String prompt, AudioResponseFormat responseFormat, Double temperature) {
        this.file = file;
        this.model = model;
        this.prompt = prompt;
        this.responseFormat = responseFormat;
        this.temperature = temperature;
    }

    public static TranslationRequestBuilder builder() {
        return new TranslationRequestBuilder();
    }

    public Path getFile() {
        return this.file;
    }

    public String getModel() {
        return this.model;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public AudioResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public TranslationRequest withResponseFormat(AudioResponseFormat responseFormat) {
        return this.responseFormat == responseFormat ? this : new TranslationRequest(this.file, this.model, this.prompt, responseFormat, this.temperature);
    }

    public static class TranslationRequestBuilder {
        private Path file;
        private String model;
        private String prompt;
        private AudioResponseFormat responseFormat;
        private Double temperature;

        TranslationRequestBuilder() {
        }

        public TranslationRequestBuilder file(Path file) {
            this.file = file;
            return this;
        }

        public TranslationRequestBuilder model(String model) {
            this.model = model;
            return this;
        }

        public TranslationRequestBuilder prompt(String prompt) {
            this.prompt = prompt;
            return this;
        }

        public TranslationRequestBuilder responseFormat(AudioResponseFormat responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        public TranslationRequestBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public TranslationRequest build() {
            return new TranslationRequest(this.file, this.model, this.prompt, this.responseFormat, this.temperature);
        }

        public String toString() {
            return "TranslationRequest.TranslationRequestBuilder(file=" + this.file + ", model=" + this.model + ", prompt=" + this.prompt + ", responseFormat=" + this.responseFormat + ", temperature=" + this.temperature + ")";
        }
    }
}

