/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.assistant;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.openai.domain.assistant.ExpiresAfter;
import io.github.sashirestela.slimvalidator.constraints.Size;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class VectorStoreModifyRequest {
    private String name;
    private ExpiresAfter expiresAfter;
    @Size(max=16)
    private Map<String, String> metadata;

    VectorStoreModifyRequest(String name, ExpiresAfter expiresAfter, Map<String, String> metadata) {
        this.name = name;
        this.expiresAfter = expiresAfter;
        this.metadata = metadata;
    }

    public static VectorStoreModifyRequestBuilder builder() {
        return new VectorStoreModifyRequestBuilder();
    }

    public String getName() {
        return this.name;
    }

    public ExpiresAfter getExpiresAfter() {
        return this.expiresAfter;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class VectorStoreModifyRequestBuilder {
        private String name;
        private ExpiresAfter expiresAfter;
        private Map<String, String> metadata;

        VectorStoreModifyRequestBuilder() {
        }

        public VectorStoreModifyRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        public VectorStoreModifyRequestBuilder expiresAfter(ExpiresAfter expiresAfter) {
            this.expiresAfter = expiresAfter;
            return this;
        }

        public VectorStoreModifyRequestBuilder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public VectorStoreModifyRequest build() {
            return new VectorStoreModifyRequest(this.name, this.expiresAfter, this.metadata);
        }

        public String toString() {
            return "VectorStoreModifyRequest.VectorStoreModifyRequestBuilder(name=" + this.name + ", expiresAfter=" + this.expiresAfter + ", metadata=" + this.metadata + ")";
        }
    }
}

