/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.assistant;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.slimvalidator.constraints.Size;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class ToolResource {
    private CodeInterpreter codeInterpreter;
    private FileSearch fileSearch;

    public static ToolResourceBuilder builder() {
        return new ToolResourceBuilder();
    }

    public ToolResource(CodeInterpreter codeInterpreter, FileSearch fileSearch) {
        this.codeInterpreter = codeInterpreter;
        this.fileSearch = fileSearch;
    }

    public ToolResource() {
    }

    public CodeInterpreter getCodeInterpreter() {
        return this.codeInterpreter;
    }

    public FileSearch getFileSearch() {
        return this.fileSearch;
    }

    public String toString() {
        return "ToolResource(codeInterpreter=" + this.getCodeInterpreter() + ", fileSearch=" + this.getFileSearch() + ")";
    }

    public static class ToolResourceBuilder {
        private CodeInterpreter codeInterpreter;
        private FileSearch fileSearch;

        ToolResourceBuilder() {
        }

        public ToolResourceBuilder codeInterpreter(CodeInterpreter codeInterpreter) {
            this.codeInterpreter = codeInterpreter;
            return this;
        }

        public ToolResourceBuilder fileSearch(FileSearch fileSearch) {
            this.fileSearch = fileSearch;
            return this;
        }

        public ToolResource build() {
            return new ToolResource(this.codeInterpreter, this.fileSearch);
        }

        public String toString() {
            return "ToolResource.ToolResourceBuilder(codeInterpreter=" + this.codeInterpreter + ", fileSearch=" + this.fileSearch + ")";
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class FileSearch {
        @Size(max=1)
        private List<String> vectorStoreIds;

        public static FileSearchBuilder builder() {
            return new FileSearchBuilder();
        }

        public FileSearch(List<String> vectorStoreIds) {
            this.vectorStoreIds = vectorStoreIds;
        }

        public FileSearch() {
        }

        public List<String> getVectorStoreIds() {
            return this.vectorStoreIds;
        }

        public String toString() {
            return "ToolResource.FileSearch(vectorStoreIds=" + this.getVectorStoreIds() + ")";
        }

        public static class FileSearchBuilder {
            private ArrayList<String> vectorStoreIds;

            FileSearchBuilder() {
            }

            public FileSearchBuilder vectorStoreId(String vectorStoreId) {
                if (this.vectorStoreIds == null) {
                    this.vectorStoreIds = new ArrayList();
                }
                this.vectorStoreIds.add(vectorStoreId);
                return this;
            }

            public FileSearchBuilder vectorStoreIds(Collection<? extends String> vectorStoreIds) {
                if (vectorStoreIds == null) {
                    throw new NullPointerException("vectorStoreIds cannot be null");
                }
                if (this.vectorStoreIds == null) {
                    this.vectorStoreIds = new ArrayList();
                }
                this.vectorStoreIds.addAll(vectorStoreIds);
                return this;
            }

            public FileSearchBuilder clearVectorStoreIds() {
                if (this.vectorStoreIds != null) {
                    this.vectorStoreIds.clear();
                }
                return this;
            }

            public FileSearch build() {
                List<String> vectorStoreIds;
                switch (this.vectorStoreIds == null ? 0 : this.vectorStoreIds.size()) {
                    case 0: {
                        vectorStoreIds = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        vectorStoreIds = Collections.singletonList(this.vectorStoreIds.get(0));
                        break;
                    }
                    default: {
                        vectorStoreIds = Collections.unmodifiableList(new ArrayList<String>(this.vectorStoreIds));
                    }
                }
                return new FileSearch(vectorStoreIds);
            }

            public String toString() {
                return "ToolResource.FileSearch.FileSearchBuilder(vectorStoreIds=" + this.vectorStoreIds + ")";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class CodeInterpreter {
        @Size(max=20)
        private List<String> fileIds;

        public static CodeInterpreterBuilder builder() {
            return new CodeInterpreterBuilder();
        }

        public CodeInterpreter(List<String> fileIds) {
            this.fileIds = fileIds;
        }

        public CodeInterpreter() {
        }

        public List<String> getFileIds() {
            return this.fileIds;
        }

        public String toString() {
            return "ToolResource.CodeInterpreter(fileIds=" + this.getFileIds() + ")";
        }

        public static class CodeInterpreterBuilder {
            private ArrayList<String> fileIds;

            CodeInterpreterBuilder() {
            }

            public CodeInterpreterBuilder fileId(String fileId) {
                if (this.fileIds == null) {
                    this.fileIds = new ArrayList();
                }
                this.fileIds.add(fileId);
                return this;
            }

            public CodeInterpreterBuilder fileIds(Collection<? extends String> fileIds) {
                if (fileIds == null) {
                    throw new NullPointerException("fileIds cannot be null");
                }
                if (this.fileIds == null) {
                    this.fileIds = new ArrayList();
                }
                this.fileIds.addAll(fileIds);
                return this;
            }

            public CodeInterpreterBuilder clearFileIds() {
                if (this.fileIds != null) {
                    this.fileIds.clear();
                }
                return this;
            }

            public CodeInterpreter build() {
                List<String> fileIds;
                switch (this.fileIds == null ? 0 : this.fileIds.size()) {
                    case 0: {
                        fileIds = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        fileIds = Collections.singletonList(this.fileIds.get(0));
                        break;
                    }
                    default: {
                        fileIds = Collections.unmodifiableList(new ArrayList<String>(this.fileIds));
                    }
                }
                return new CodeInterpreter(fileIds);
            }

            public String toString() {
                return "ToolResource.CodeInterpreter.CodeInterpreterBuilder(fileIds=" + this.fileIds + ")";
            }
        }
    }
}

