/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.assistant;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.openai.common.tool.ToolType;
import io.github.sashirestela.openai.domain.assistant.RunStepType;
import java.util.List;
import java.util.Map;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=MessageCreationStep.class, name="message_creation"), @JsonSubTypes.Type(value=ToolCallsStep.class, name="tool_calls")})
public class StepDetail {
    protected RunStepType type;

    public RunStepType getType() {
        return this.type;
    }

    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class ToolCallsStep
    extends StepDetail {
        private List<StepToolCall> toolCalls;

        public List<StepToolCall> getToolCalls() {
            return this.toolCalls;
        }

        public String toString() {
            return "StepDetail.ToolCallsStep(toolCalls=" + this.getToolCalls() + ")";
        }

        @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type")
        @JsonSubTypes(value={@JsonSubTypes.Type(value=CodeInterpreterToolCall.class, name="code_interpreter"), @JsonSubTypes.Type(value=FileSearchToolCall.class, name="file_search"), @JsonSubTypes.Type(value=FunctionToolCall.class, name="function")})
        public static abstract class StepToolCall {
            protected Integer index;
            protected String id;
            protected ToolType type;

            public Integer getIndex() {
                return this.index;
            }

            public String getId() {
                return this.id;
            }

            public ToolType getType() {
                return this.type;
            }

            @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
            public static class FunctionToolCall
            extends StepToolCall {
                private FunctionTool function;

                public FunctionTool getFunction() {
                    return this.function;
                }

                public String toString() {
                    return "StepDetail.ToolCallsStep.StepToolCall.FunctionToolCall(function=" + this.getFunction() + ")";
                }

                @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
                public static class FunctionTool {
                    private String name;
                    private String arguments;
                    private String output;

                    public String getName() {
                        return this.name;
                    }

                    public String getArguments() {
                        return this.arguments;
                    }

                    public String getOutput() {
                        return this.output;
                    }

                    public String toString() {
                        return "StepDetail.ToolCallsStep.StepToolCall.FunctionToolCall.FunctionTool(name=" + this.getName() + ", arguments=" + this.getArguments() + ", output=" + this.getOutput() + ")";
                    }
                }
            }

            @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
            public static class FileSearchToolCall
            extends StepToolCall {
                private Map<String, String> fileSearch;

                public Map<String, String> getFileSearch() {
                    return this.fileSearch;
                }

                public String toString() {
                    return "StepDetail.ToolCallsStep.StepToolCall.FileSearchToolCall(fileSearch=" + this.getFileSearch() + ")";
                }
            }

            @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
            public static class CodeInterpreterToolCall
            extends StepToolCall {
                private CodeInterpreterTool codeInterpreter;

                public CodeInterpreterTool getCodeInterpreter() {
                    return this.codeInterpreter;
                }

                public String toString() {
                    return "StepDetail.ToolCallsStep.StepToolCall.CodeInterpreterToolCall(codeInterpreter=" + this.getCodeInterpreter() + ")";
                }

                @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
                public static class CodeInterpreterTool {
                    private String input;
                    private List<Output> outputs;

                    public String getInput() {
                        return this.input;
                    }

                    public List<Output> getOutputs() {
                        return this.outputs;
                    }

                    public String toString() {
                        return "StepDetail.ToolCallsStep.StepToolCall.CodeInterpreterToolCall.CodeInterpreterTool(input=" + this.getInput() + ", outputs=" + this.getOutputs() + ")";
                    }

                    public static enum OutputType {
                        LOGS,
                        IMAGE;

                    }

                    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type")
                    @JsonSubTypes(value={@JsonSubTypes.Type(value=LogOutput.class, name="logs"), @JsonSubTypes.Type(value=ImageOutput.class, name="image")})
                    public static abstract class Output {
                        protected Integer index;
                        protected OutputType type;

                        public Integer getIndex() {
                            return this.index;
                        }

                        public OutputType getType() {
                            return this.type;
                        }

                        @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
                        public static class ImageOutput
                        extends Output {
                            private ImageOutputFile image;

                            public ImageOutputFile getImage() {
                                return this.image;
                            }

                            public String toString() {
                                return "StepDetail.ToolCallsStep.StepToolCall.CodeInterpreterToolCall.CodeInterpreterTool.Output.ImageOutput(image=" + this.getImage() + ")";
                            }

                            @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
                            public static class ImageOutputFile {
                                private String fileId;

                                public String getFileId() {
                                    return this.fileId;
                                }

                                public String toString() {
                                    return "StepDetail.ToolCallsStep.StepToolCall.CodeInterpreterToolCall.CodeInterpreterTool.Output.ImageOutput.ImageOutputFile(fileId=" + this.getFileId() + ")";
                                }
                            }
                        }

                        @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
                        public static class LogOutput
                        extends Output {
                            private String logs;

                            public String getLogs() {
                                return this.logs;
                            }

                            public String toString() {
                                return "StepDetail.ToolCallsStep.StepToolCall.CodeInterpreterToolCall.CodeInterpreterTool.Output.LogOutput(logs=" + this.getLogs() + ")";
                            }
                        }
                    }
                }
            }
        }
    }

    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class MessageCreationStep
    extends StepDetail {
        private MessageCreation messageCreation;

        public MessageCreation getMessageCreation() {
            return this.messageCreation;
        }

        public String toString() {
            return "StepDetail.MessageCreationStep(messageCreation=" + this.getMessageCreation() + ")";
        }

        @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
        public static class MessageCreation {
            private String messageId;

            public String getMessageId() {
                return this.messageId;
            }

            public String toString() {
                return "StepDetail.MessageCreationStep.MessageCreation(messageId=" + this.getMessageId() + ")";
            }
        }
    }
}

