/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.assistant;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.openai.common.tool.ToolType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class Attachment {
    private String fileId;
    private List<AttachmentTool> tools;

    public static AttachmentBuilder builder() {
        return new AttachmentBuilder();
    }

    public Attachment(String fileId, List<AttachmentTool> tools) {
        this.fileId = fileId;
        this.tools = tools;
    }

    public Attachment() {
    }

    public String getFileId() {
        return this.fileId;
    }

    public List<AttachmentTool> getTools() {
        return this.tools;
    }

    public String toString() {
        return "Attachment(fileId=" + this.getFileId() + ", tools=" + this.getTools() + ")";
    }

    public static class AttachmentBuilder {
        private String fileId;
        private ArrayList<AttachmentTool> tools;

        AttachmentBuilder() {
        }

        public AttachmentBuilder fileId(String fileId) {
            this.fileId = fileId;
            return this;
        }

        public AttachmentBuilder tool(AttachmentTool tool) {
            if (this.tools == null) {
                this.tools = new ArrayList();
            }
            this.tools.add(tool);
            return this;
        }

        public AttachmentBuilder tools(Collection<? extends AttachmentTool> tools) {
            if (tools == null) {
                throw new NullPointerException("tools cannot be null");
            }
            if (this.tools == null) {
                this.tools = new ArrayList();
            }
            this.tools.addAll(tools);
            return this;
        }

        public AttachmentBuilder clearTools() {
            if (this.tools != null) {
                this.tools.clear();
            }
            return this;
        }

        public Attachment build() {
            List<AttachmentTool> tools;
            switch (this.tools == null ? 0 : this.tools.size()) {
                case 0: {
                    tools = Collections.emptyList();
                    break;
                }
                case 1: {
                    tools = Collections.singletonList(this.tools.get(0));
                    break;
                }
                default: {
                    tools = Collections.unmodifiableList(new ArrayList<AttachmentTool>(this.tools));
                }
            }
            return new Attachment(this.fileId, tools);
        }

        public String toString() {
            return "Attachment.AttachmentBuilder(fileId=" + this.fileId + ", tools=" + this.tools + ")";
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class AttachmentTool {
        public static final AttachmentTool CODE_INTERPRETER = new AttachmentTool(ToolType.CODE_INTERPRETER);
        public static final AttachmentTool FILE_SEARCH = new AttachmentTool(ToolType.FILE_SEARCH);
        private ToolType type;

        public AttachmentTool(ToolType type) {
            this.type = type;
        }

        public AttachmentTool() {
        }

        public ToolType getType() {
            return this.type;
        }

        public String toString() {
            return "Attachment.AttachmentTool(type=" + this.getType() + ")";
        }
    }
}

