/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.common.function;

import io.github.sashirestela.openai.common.function.Functional;
import lombok.NonNull;

public class FunctionDef {
    @NonNull
    private String name;
    private String description;
    @NonNull
    private Class<? extends Functional> functionalClass;

    FunctionDef(@NonNull String name, String description, @NonNull Class<? extends Functional> functionalClass) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (functionalClass == null) {
            throw new NullPointerException("functionalClass is marked non-null but is null");
        }
        this.name = name;
        this.description = description;
        this.functionalClass = functionalClass;
    }

    public static FunctionDefBuilder builder() {
        return new FunctionDefBuilder();
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    @NonNull
    public Class<? extends Functional> getFunctionalClass() {
        return this.functionalClass;
    }

    public static class FunctionDefBuilder {
        private String name;
        private String description;
        private Class<? extends Functional> functionalClass;

        FunctionDefBuilder() {
        }

        public FunctionDefBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        public FunctionDefBuilder description(String description) {
            this.description = description;
            return this;
        }

        public FunctionDefBuilder functionalClass(@NonNull Class<? extends Functional> functionalClass) {
            if (functionalClass == null) {
                throw new NullPointerException("functionalClass is marked non-null but is null");
            }
            this.functionalClass = functionalClass;
            return this;
        }

        public FunctionDef build() {
            return new FunctionDef(this.name, this.description, this.functionalClass);
        }

        public String toString() {
            return "FunctionDef.FunctionDefBuilder(name=" + this.name + ", description=" + this.description + ", functionalClass=" + this.functionalClass + ")";
        }
    }
}

