/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai;

import io.github.sashirestela.cleverclient.http.HttpRequestData;
import io.github.sashirestela.cleverclient.support.ContentType;
import io.github.sashirestela.openai.BaseSimpleOpenAI;
import io.github.sashirestela.openai.BaseSimpleOpenAIArgs;
import java.net.http.HttpClient;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.NonNull;

public class SimpleOpenAIAzure
extends BaseSimpleOpenAI {
    public SimpleOpenAIAzure(@NonNull String apiKey, @NonNull String baseUrl, @NonNull String apiVersion, HttpClient httpClient) {
        super(SimpleOpenAIAzure.prepareBaseSimpleOpenAIArgs(apiKey, baseUrl, apiVersion, httpClient));
        if (apiKey == null) {
            throw new NullPointerException("apiKey is marked non-null but is null");
        }
        if (baseUrl == null) {
            throw new NullPointerException("baseUrl is marked non-null but is null");
        }
        if (apiVersion == null) {
            throw new NullPointerException("apiVersion is marked non-null but is null");
        }
    }

    private static String extractDeployment(String url) {
        String DEPLOYMENT_REGEX = "/deployments/([^/]+)/";
        Pattern pattern = Pattern.compile("/deployments/([^/]+)/");
        Matcher matcher = pattern.matcher(url);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private static String getNewUrl(String url, String apiVersion) {
        String VERSION_REGEX = "(/v\\d+\\.*\\d*)";
        String DEPLOYMENT_REGEX = "/deployments/[^/]+/";
        String CHAT_COMPLETIONS_LITERAL = "/chat/completions";
        url = (String)url + (((String)url).contains("?") ? "&" : "?") + "api-version=" + apiVersion;
        if (!((String)(url = ((String)url).replaceFirst("(/v\\d+\\.*\\d*)", ""))).contains("/chat/completions")) {
            url = ((String)url).replaceFirst("/deployments/[^/]+/", "/");
        }
        return url;
    }

    private static Object getBodyForJson(String url, String body, String deployment) {
        String MODEL_REGEX = ",?\"model\":\"[^\"]*\",?";
        String EMPTY_REGEX = "\"\"";
        String QUOTED_COMMA = "\",\"";
        String MODEL_LITERAL = "model";
        String ASSISTANTS_LITERAL = "/assistants";
        Object model = "";
        if (url.contains("/assistants")) {
            model = "\"model\":\"" + deployment + "\"";
        }
        body = body.replaceFirst(",?\"model\":\"[^\"]*\",?", (String)model);
        body = body.replaceFirst("\"\"", "\",\"");
        return body;
    }

    private static Object getBodyForMap(String url, Map<String, Object> body, String deployment) {
        String ASSISTANTS_LITERAL = "/assistants";
        String MODEL_LITERAL = "model";
        if (url.contains("/assistants")) {
            body.put("model", deployment);
        } else {
            body.remove("model");
        }
        return body;
    }

    private static Object getNewBody(HttpRequestData request, ContentType contentType, String url) {
        String deployment = SimpleOpenAIAzure.extractDeployment(url);
        Object body = request.getBody();
        if (contentType.equals((Object)ContentType.APPLICATION_JSON)) {
            return SimpleOpenAIAzure.getBodyForJson(url, (String)body, deployment);
        }
        return SimpleOpenAIAzure.getBodyForMap(url, (Map)body, deployment);
    }

    public static BaseSimpleOpenAIArgs prepareBaseSimpleOpenAIArgs(String apiKey, String baseUrl, String apiVersion, HttpClient httpClient) {
        Map<String, String> headers = Map.of("api-key", apiKey);
        UnaryOperator requestInterceptor = request -> {
            String url = request.getUrl();
            ContentType contentType = request.getContentType();
            if (contentType != null) {
                Object body = SimpleOpenAIAzure.getNewBody(request, contentType, url);
                request.setBody(body);
            }
            url = SimpleOpenAIAzure.getNewUrl(url, apiVersion);
            request.setUrl(url);
            return request;
        };
        return BaseSimpleOpenAIArgs.builder().baseUrl(baseUrl).headers(headers).httpClient(httpClient).requestInterceptor(requestInterceptor).build();
    }

    public static SimpleOpenAIAzureBuilder builder() {
        return new SimpleOpenAIAzureBuilder();
    }

    public static class SimpleOpenAIAzureBuilder {
        private String apiKey;
        private String baseUrl;
        private String apiVersion;
        private HttpClient httpClient;

        SimpleOpenAIAzureBuilder() {
        }

        public SimpleOpenAIAzureBuilder apiKey(@NonNull String apiKey) {
            if (apiKey == null) {
                throw new NullPointerException("apiKey is marked non-null but is null");
            }
            this.apiKey = apiKey;
            return this;
        }

        public SimpleOpenAIAzureBuilder baseUrl(@NonNull String baseUrl) {
            if (baseUrl == null) {
                throw new NullPointerException("baseUrl is marked non-null but is null");
            }
            this.baseUrl = baseUrl;
            return this;
        }

        public SimpleOpenAIAzureBuilder apiVersion(@NonNull String apiVersion) {
            if (apiVersion == null) {
                throw new NullPointerException("apiVersion is marked non-null but is null");
            }
            this.apiVersion = apiVersion;
            return this;
        }

        public SimpleOpenAIAzureBuilder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public SimpleOpenAIAzure build() {
            return new SimpleOpenAIAzure(this.apiKey, this.baseUrl, this.apiVersion, this.httpClient);
        }

        public String toString() {
            return "SimpleOpenAIAzure.SimpleOpenAIAzureBuilder(apiKey=" + this.apiKey + ", baseUrl=" + this.baseUrl + ", apiVersion=" + this.apiVersion + ", httpClient=" + this.httpClient + ")";
        }
    }
}

