/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.finetuning;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.slimvalidator.constraints.Required;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class WandbIntegration {
    @Required
    private String project;
    private String name;
    private String entity;
    private List<String> tags;

    public static WandbIntegrationBuilder builder() {
        return new WandbIntegrationBuilder();
    }

    public WandbIntegration() {
    }

    public WandbIntegration(String project, String name, String entity, List<String> tags) {
        this.project = project;
        this.name = name;
        this.entity = entity;
        this.tags = tags;
    }

    public String getProject() {
        return this.project;
    }

    public String getName() {
        return this.name;
    }

    public String getEntity() {
        return this.entity;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public static class WandbIntegrationBuilder {
        private String project;
        private String name;
        private String entity;
        private ArrayList<String> tags;

        WandbIntegrationBuilder() {
        }

        public WandbIntegrationBuilder project(String project) {
            this.project = project;
            return this;
        }

        public WandbIntegrationBuilder name(String name) {
            this.name = name;
            return this;
        }

        public WandbIntegrationBuilder entity(String entity) {
            this.entity = entity;
            return this;
        }

        public WandbIntegrationBuilder tag(String tag) {
            if (this.tags == null) {
                this.tags = new ArrayList();
            }
            this.tags.add(tag);
            return this;
        }

        public WandbIntegrationBuilder tags(Collection<? extends String> tags) {
            if (tags == null) {
                throw new NullPointerException("tags cannot be null");
            }
            if (this.tags == null) {
                this.tags = new ArrayList();
            }
            this.tags.addAll(tags);
            return this;
        }

        public WandbIntegrationBuilder clearTags() {
            if (this.tags != null) {
                this.tags.clear();
            }
            return this;
        }

        public WandbIntegration build() {
            List<String> tags;
            switch (this.tags == null ? 0 : this.tags.size()) {
                case 0: {
                    tags = Collections.emptyList();
                    break;
                }
                case 1: {
                    tags = Collections.singletonList(this.tags.get(0));
                    break;
                }
                default: {
                    tags = Collections.unmodifiableList(new ArrayList<String>(this.tags));
                }
            }
            return new WandbIntegration(this.project, this.name, this.entity, tags);
        }

        public String toString() {
            return "WandbIntegration.WandbIntegrationBuilder(project=" + this.project + ", name=" + this.name + ", entity=" + this.entity + ", tags=" + this.tags + ")";
        }
    }
}

