/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai;

import io.github.sashirestela.cleverclient.CleverClient;
import io.github.sashirestela.openai.BaseSimpleOpenAIArgs;
import io.github.sashirestela.openai.OpenAI;
import io.github.sashirestela.openai.OpenAIBeta;
import io.github.sashirestela.slimvalidator.Validator;
import io.github.sashirestela.slimvalidator.exception.ConstraintViolationException;
import java.net.http.HttpClient;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import lombok.NonNull;

public abstract class BaseSimpleOpenAI {
    private static final String END_OF_STREAM = "[DONE]";
    protected static final String NOT_IMPLEMENTED = "Not implemented.";
    protected CleverClient cleverClient;
    protected OpenAI.Audios audioService;
    protected OpenAI.Batches batchService;
    protected OpenAI.ChatCompletions chatCompletionService;
    protected OpenAI.Completions completionService;
    protected OpenAI.Embeddings embeddingService;
    protected OpenAI.Files fileService;
    protected OpenAI.FineTunings fineTuningService;
    protected OpenAI.Images imageService;
    protected OpenAI.Models modelService;
    protected OpenAI.Moderations moderationService;
    protected OpenAIBeta.Assistants assistantService;
    protected OpenAIBeta.Threads threadService;

    BaseSimpleOpenAI(@NonNull BaseSimpleOpenAIArgs args) {
        if (args == null) {
            throw new NullPointerException("args is marked non-null but is null");
        }
        HttpClient httpClient = Optional.ofNullable(args.getHttpClient()).orElse(HttpClient.newHttpClient());
        Consumer<Object> bodyInspector = body -> {
            Validator validator = new Validator();
            List violations = validator.validate(body);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        };
        this.cleverClient = CleverClient.builder().httpClient(httpClient).baseUrl(args.getBaseUrl()).headers(args.getHeaders()).endOfStream(END_OF_STREAM).requestInterceptor(args.getRequestInterceptor()).bodyInspector(bodyInspector).build();
    }

    public OpenAI.Audios audios() {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED);
    }

    public OpenAI.Batches batches() {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED);
    }

    public OpenAI.ChatCompletions chatCompletions() {
        if (this.chatCompletionService == null) {
            this.chatCompletionService = (OpenAI.ChatCompletions)this.cleverClient.create(OpenAI.ChatCompletions.class);
        }
        return this.chatCompletionService;
    }

    public OpenAI.Completions completions() {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED);
    }

    public OpenAI.Embeddings embeddings() {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED);
    }

    public OpenAI.Files files() {
        if (this.fileService == null) {
            this.fileService = (OpenAI.Files)this.cleverClient.create(OpenAI.Files.class);
        }
        return this.fileService;
    }

    public OpenAI.FineTunings fineTunings() {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED);
    }

    public OpenAI.Images images() {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED);
    }

    public OpenAI.Models models() {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED);
    }

    public OpenAI.Moderations moderations() {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED);
    }

    public OpenAIBeta.Assistants assistants() {
        if (this.assistantService == null) {
            this.assistantService = (OpenAIBeta.Assistants)this.cleverClient.create(OpenAIBeta.Assistants.class);
        }
        return this.assistantService;
    }

    public OpenAIBeta.Threads threads() {
        if (this.threadService == null) {
            this.threadService = (OpenAIBeta.Threads)this.cleverClient.create(OpenAIBeta.Threads.class);
        }
        return this.threadService;
    }

    public void setCleverClient(CleverClient cleverClient) {
        this.cleverClient = cleverClient;
    }
}

