/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.finetuning;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.slimvalidator.constraints.ObjectType;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class HyperParams {
    @ObjectType.List(value={@ObjectType(baseClass=Integer.class), @ObjectType(baseClass=String.class)})
    private Object batchSize;
    @ObjectType.List(value={@ObjectType(baseClass=Double.class), @ObjectType(baseClass=String.class)})
    private Object learningRateMultiplier;
    @ObjectType.List(value={@ObjectType(baseClass=Integer.class), @ObjectType(baseClass=String.class)})
    private Object nEpochs;

    public static HyperParamsBuilder builder() {
        return new HyperParamsBuilder();
    }

    public Object getBatchSize() {
        return this.batchSize;
    }

    public Object getLearningRateMultiplier() {
        return this.learningRateMultiplier;
    }

    public Object getNEpochs() {
        return this.nEpochs;
    }

    public HyperParams() {
    }

    private HyperParams(Object batchSize, Object learningRateMultiplier, Object nEpochs) {
        this.batchSize = batchSize;
        this.learningRateMultiplier = learningRateMultiplier;
        this.nEpochs = nEpochs;
    }

    public String toString() {
        return "HyperParams(batchSize=" + this.getBatchSize() + ", learningRateMultiplier=" + this.getLearningRateMultiplier() + ", nEpochs=" + this.getNEpochs() + ")";
    }

    public static class HyperParamsBuilder {
        private Object batchSize;
        private Object learningRateMultiplier;
        private Object nEpochs;

        HyperParamsBuilder() {
        }

        public HyperParamsBuilder batchSize(Object batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public HyperParamsBuilder learningRateMultiplier(Object learningRateMultiplier) {
            this.learningRateMultiplier = learningRateMultiplier;
            return this;
        }

        public HyperParamsBuilder nEpochs(Object nEpochs) {
            this.nEpochs = nEpochs;
            return this;
        }

        public HyperParams build() {
            return new HyperParams(this.batchSize, this.learningRateMultiplier, this.nEpochs);
        }

        public String toString() {
            return "HyperParams.HyperParamsBuilder(batchSize=" + this.batchSize + ", learningRateMultiplier=" + this.learningRateMultiplier + ", nEpochs=" + this.nEpochs + ")";
        }
    }
}

