/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.audio;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.openai.domain.audio.AudioRespFmt;
import io.github.sashirestela.openai.domain.audio.TimestampGranularity;
import io.github.sashirestela.slimvalidator.constraints.Extension;
import io.github.sashirestela.slimvalidator.constraints.Range;
import io.github.sashirestela.slimvalidator.constraints.Required;
import io.github.sashirestela.slimvalidator.constraints.Size;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class AudioTranscribeRequest {
    @Required
    @Extension(value={"flac", "mp3", "mp4", "mpeg", "mpga", "m4a", "ogg", "wav", "webm"})
    private Path file;
    @Required
    private String model;
    private String language;
    private String prompt;
    private AudioRespFmt responseFormat;
    @Range(min=0.0, max=1.0)
    private Double temperature;
    @Size(max=2)
    private Set<TimestampGranularity> timestampGranularities;

    AudioTranscribeRequest(Path file, String model, String language, String prompt, AudioRespFmt responseFormat, Double temperature, Set<TimestampGranularity> timestampGranularities) {
        this.file = file;
        this.model = model;
        this.language = language;
        this.prompt = prompt;
        this.responseFormat = responseFormat;
        this.temperature = temperature;
        this.timestampGranularities = timestampGranularities;
    }

    public static AudioTranscribeRequestBuilder builder() {
        return new AudioTranscribeRequestBuilder();
    }

    public Path getFile() {
        return this.file;
    }

    public String getModel() {
        return this.model;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public AudioRespFmt getResponseFormat() {
        return this.responseFormat;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public Set<TimestampGranularity> getTimestampGranularities() {
        return this.timestampGranularities;
    }

    public AudioTranscribeRequest withResponseFormat(AudioRespFmt responseFormat) {
        return this.responseFormat == responseFormat ? this : new AudioTranscribeRequest(this.file, this.model, this.language, this.prompt, responseFormat, this.temperature, this.timestampGranularities);
    }

    public static class AudioTranscribeRequestBuilder {
        private Path file;
        private String model;
        private String language;
        private String prompt;
        private AudioRespFmt responseFormat;
        private Double temperature;
        private ArrayList<TimestampGranularity> timestampGranularities;

        AudioTranscribeRequestBuilder() {
        }

        public AudioTranscribeRequestBuilder file(Path file) {
            this.file = file;
            return this;
        }

        public AudioTranscribeRequestBuilder model(String model) {
            this.model = model;
            return this;
        }

        public AudioTranscribeRequestBuilder language(String language) {
            this.language = language;
            return this;
        }

        public AudioTranscribeRequestBuilder prompt(String prompt) {
            this.prompt = prompt;
            return this;
        }

        public AudioTranscribeRequestBuilder responseFormat(AudioRespFmt responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        public AudioTranscribeRequestBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public AudioTranscribeRequestBuilder timestampGranularity(TimestampGranularity timestampGranularity) {
            if (this.timestampGranularities == null) {
                this.timestampGranularities = new ArrayList();
            }
            this.timestampGranularities.add(timestampGranularity);
            return this;
        }

        public AudioTranscribeRequestBuilder timestampGranularities(Collection<? extends TimestampGranularity> timestampGranularities) {
            if (timestampGranularities == null) {
                throw new NullPointerException("timestampGranularities cannot be null");
            }
            if (this.timestampGranularities == null) {
                this.timestampGranularities = new ArrayList();
            }
            this.timestampGranularities.addAll(timestampGranularities);
            return this;
        }

        public AudioTranscribeRequestBuilder clearTimestampGranularities() {
            if (this.timestampGranularities != null) {
                this.timestampGranularities.clear();
            }
            return this;
        }

        public AudioTranscribeRequest build() {
            Set<Object> timestampGranularities;
            switch (this.timestampGranularities == null ? 0 : this.timestampGranularities.size()) {
                case 0: {
                    timestampGranularities = Collections.emptySet();
                    break;
                }
                case 1: {
                    timestampGranularities = Collections.singleton(this.timestampGranularities.get(0));
                    break;
                }
                default: {
                    timestampGranularities = new LinkedHashSet(this.timestampGranularities.size() < 0x40000000 ? 1 + this.timestampGranularities.size() + (this.timestampGranularities.size() - 3) / 3 : Integer.MAX_VALUE);
                    timestampGranularities.addAll(this.timestampGranularities);
                    timestampGranularities = Collections.unmodifiableSet(timestampGranularities);
                }
            }
            return new AudioTranscribeRequest(this.file, this.model, this.language, this.prompt, this.responseFormat, this.temperature, timestampGranularities);
        }

        public String toString() {
            return "AudioTranscribeRequest.AudioTranscribeRequestBuilder(file=" + this.file + ", model=" + this.model + ", language=" + this.language + ", prompt=" + this.prompt + ", responseFormat=" + this.responseFormat + ", temperature=" + this.temperature + ", timestampGranularities=" + this.timestampGranularities + ")";
        }
    }
}

