/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai;

import io.github.sashirestela.cleverclient.annotation.Body;
import io.github.sashirestela.cleverclient.annotation.DELETE;
import io.github.sashirestela.cleverclient.annotation.GET;
import io.github.sashirestela.cleverclient.annotation.Multipart;
import io.github.sashirestela.cleverclient.annotation.POST;
import io.github.sashirestela.cleverclient.annotation.Path;
import io.github.sashirestela.cleverclient.annotation.Query;
import io.github.sashirestela.cleverclient.annotation.Resource;
import io.github.sashirestela.cleverclient.util.CommonUtil;
import io.github.sashirestela.openai.SimpleUncheckedException;
import io.github.sashirestela.openai.domain.OpenAIDeletedResponse;
import io.github.sashirestela.openai.domain.OpenAIGeneric;
import io.github.sashirestela.openai.domain.Page;
import io.github.sashirestela.openai.domain.audio.AudioRespFmt;
import io.github.sashirestela.openai.domain.audio.AudioResponse;
import io.github.sashirestela.openai.domain.audio.AudioSpeechRequest;
import io.github.sashirestela.openai.domain.audio.AudioTranscribeRequest;
import io.github.sashirestela.openai.domain.audio.AudioTranslateRequest;
import io.github.sashirestela.openai.domain.batch.BatchRequest;
import io.github.sashirestela.openai.domain.batch.BatchResponse;
import io.github.sashirestela.openai.domain.chat.ChatRequest;
import io.github.sashirestela.openai.domain.chat.ChatResponse;
import io.github.sashirestela.openai.domain.chat.tool.ChatToolChoiceType;
import io.github.sashirestela.openai.domain.completion.CompletionRequest;
import io.github.sashirestela.openai.domain.completion.CompletionResponse;
import io.github.sashirestela.openai.domain.embedding.EmbeddingBase64Response;
import io.github.sashirestela.openai.domain.embedding.EmbeddingFloatResponse;
import io.github.sashirestela.openai.domain.embedding.EmbeddingRequest;
import io.github.sashirestela.openai.domain.embedding.EncodingFormat;
import io.github.sashirestela.openai.domain.file.FileRequest;
import io.github.sashirestela.openai.domain.file.FileResponse;
import io.github.sashirestela.openai.domain.finetuning.Checkpoint;
import io.github.sashirestela.openai.domain.finetuning.FineTuningEvent;
import io.github.sashirestela.openai.domain.finetuning.FineTuningRequest;
import io.github.sashirestela.openai.domain.finetuning.FineTuningResponse;
import io.github.sashirestela.openai.domain.image.ImageEditsRequest;
import io.github.sashirestela.openai.domain.image.ImageRequest;
import io.github.sashirestela.openai.domain.image.ImageResponse;
import io.github.sashirestela.openai.domain.image.ImageVariationsRequest;
import io.github.sashirestela.openai.domain.model.ModelResponse;
import io.github.sashirestela.openai.domain.moderation.ModerationRequest;
import io.github.sashirestela.openai.domain.moderation.ModerationResponse;
import java.io.InputStream;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;

public interface OpenAI {
    public static AudioRespFmt getResponseFormat(AudioRespFmt currValue, AudioRespFmt orDefault, String methodName) {
        EnumSet<AudioRespFmt> jsonEnumSet = EnumSet.of(AudioRespFmt.JSON, AudioRespFmt.VERBOSE_JSON);
        EnumSet<AudioRespFmt> textEnumSet = EnumSet.complementOf(jsonEnumSet);
        boolean isText = textEnumSet.contains((Object)orDefault);
        AudioRespFmt requestedFormat = currValue;
        if (requestedFormat != null) {
            if (isText != textEnumSet.contains((Object)requestedFormat)) {
                throw new SimpleUncheckedException("Unexpected responseFormat for the method {0}.", methodName, null);
            }
        } else {
            requestedFormat = orDefault;
        }
        return requestedFormat;
    }

    public static ChatRequest updateRequest(ChatRequest chatRequest, Boolean useStream) {
        ChatRequest updatedChatRequest = chatRequest.withStream(useStream);
        if (!CommonUtil.isNullOrEmpty(chatRequest.getTools()) && chatRequest.getToolChoice() == null) {
            updatedChatRequest = updatedChatRequest.withToolChoice((Object)ChatToolChoiceType.AUTO);
        }
        return updatedChatRequest;
    }

    @Resource(value="/v1/moderations")
    public static interface Moderations {
        @POST
        public CompletableFuture<ModerationResponse> create(@Body ModerationRequest var1);
    }

    @Resource(value="/v1/models")
    public static interface Models {
        default public CompletableFuture<List<ModelResponse>> getList() {
            return this.getListRoot().thenApply(OpenAIGeneric::getData);
        }

        @GET
        public CompletableFuture<OpenAIGeneric<ModelResponse>> getListRoot();

        @GET(value="/{modelId}")
        public CompletableFuture<ModelResponse> getOne(@Path(value="modelId") String var1);

        @DELETE(value="/{modelId}")
        public CompletableFuture<OpenAIDeletedResponse> delete(@Path(value="modelId") String var1);
    }

    @Resource(value="/v1/images")
    public static interface Images {
        default public CompletableFuture<List<ImageResponse>> create(ImageRequest imageRequest) {
            return this.createRoot(imageRequest).thenApply(OpenAIGeneric::getData);
        }

        @POST(value="/generations")
        public CompletableFuture<OpenAIGeneric<ImageResponse>> createRoot(@Body ImageRequest var1);

        default public CompletableFuture<List<ImageResponse>> createEdits(ImageEditsRequest imageRequest) {
            return this.createEditsRoot(imageRequest).thenApply(OpenAIGeneric::getData);
        }

        @Multipart
        @POST(value="/edits")
        public CompletableFuture<OpenAIGeneric<ImageResponse>> createEditsRoot(@Body ImageEditsRequest var1);

        default public CompletableFuture<List<ImageResponse>> createVariations(ImageVariationsRequest imageRequest) {
            return this.createVariationsRoot(imageRequest).thenApply(OpenAIGeneric::getData);
        }

        @Multipart
        @POST(value="/variations")
        public CompletableFuture<OpenAIGeneric<ImageResponse>> createVariationsRoot(@Body ImageVariationsRequest var1);
    }

    @Resource(value="/v1/fine_tuning/jobs")
    public static interface FineTunings {
        @POST
        public CompletableFuture<FineTuningResponse> create(@Body FineTuningRequest var1);

        default public CompletableFuture<List<FineTuningResponse>> getList(Integer limit, String after) {
            return this.getListRoot(limit, after).thenApply(OpenAIGeneric::getData);
        }

        @GET
        public CompletableFuture<OpenAIGeneric<FineTuningResponse>> getListRoot(@Query(value="limit") Integer var1, @Query(value="after") String var2);

        @GET(value="/{fineTuningId}")
        public CompletableFuture<FineTuningResponse> getOne(@Path(value="fineTuningId") String var1);

        default public CompletableFuture<List<FineTuningEvent>> getEvents(String fineTuningId, Integer limit, String after) {
            return this.getEventsRoot(fineTuningId, limit, after).thenApply(OpenAIGeneric::getData);
        }

        @GET(value="/{fineTuningId}/events")
        public CompletableFuture<OpenAIGeneric<FineTuningEvent>> getEventsRoot(@Path(value="fineTuningId") String var1, @Query(value="limit") Integer var2, @Query(value="after") String var3);

        default public CompletableFuture<List<Checkpoint>> getCheckpoints(String fineTuningId, Integer limit, String after) {
            return this.getCheckpointsRoot(fineTuningId, limit, after).thenApply(OpenAIGeneric::getData);
        }

        @GET(value="/{fineTuningId}/checkpoints")
        public CompletableFuture<OpenAIGeneric<Checkpoint>> getCheckpointsRoot(@Path(value="fineTuningId") String var1, @Query(value="limit") Integer var2, @Query(value="after") String var3);

        @POST(value="/{fineTuningId}/cancel")
        public CompletableFuture<FineTuningResponse> cancel(@Path(value="fineTuningId") String var1);
    }

    @Resource(value="/v1/files")
    public static interface Files {
        @Multipart
        @POST
        public CompletableFuture<FileResponse> create(@Body FileRequest var1);

        default public CompletableFuture<List<FileResponse>> getList(String purpose) {
            return this.getListRoot(purpose).thenApply(OpenAIGeneric::getData);
        }

        @GET
        public CompletableFuture<OpenAIGeneric<FileResponse>> getListRoot(@Query(value="purpose") String var1);

        @GET(value="/{fileId}")
        public CompletableFuture<FileResponse> getOne(@Path(value="fileId") String var1);

        @GET(value="/{fileId}/content")
        public CompletableFuture<String> getContent(@Path(value="fileId") String var1);

        @GET(value="/{fileId}/content")
        public CompletableFuture<InputStream> getContentInputStream(@Path(value="fileId") String var1);

        @DELETE(value="/{fileId}")
        public CompletableFuture<OpenAIDeletedResponse> delete(@Path(value="fileId") String var1);
    }

    @Resource(value="/v1/embeddings")
    public static interface Embeddings {
        default public CompletableFuture<EmbeddingFloatResponse> create(@Body EmbeddingRequest embeddingRequest) {
            EmbeddingRequest request = embeddingRequest.withEncodingFormat(EncodingFormat.FLOAT);
            return this.createRoot(request);
        }

        @POST
        public CompletableFuture<EmbeddingFloatResponse> createRoot(@Body EmbeddingRequest var1);

        default public CompletableFuture<EmbeddingBase64Response> createBase64(@Body EmbeddingRequest embeddingRequest) {
            EmbeddingRequest request = embeddingRequest.withEncodingFormat(EncodingFormat.BASE64);
            return this.createBase64Root(request);
        }

        @POST
        public CompletableFuture<EmbeddingBase64Response> createBase64Root(@Body EmbeddingRequest var1);
    }

    @Resource(value="/v1/completions")
    public static interface Completions {
        default public CompletableFuture<CompletionResponse> create(@Body CompletionRequest completionRequest) {
            CompletionRequest request = completionRequest.withStream(Boolean.FALSE);
            return this.createRoot(request);
        }

        @POST
        public CompletableFuture<CompletionResponse> createRoot(@Body CompletionRequest var1);

        default public CompletableFuture<Stream<CompletionResponse>> createStream(@Body CompletionRequest completionRequest) {
            CompletionRequest request = completionRequest.withStream(Boolean.TRUE);
            return this.createStreamRoot(request);
        }

        @POST
        public CompletableFuture<Stream<CompletionResponse>> createStreamRoot(@Body CompletionRequest var1);
    }

    @Resource(value="/v1/chat/completions")
    public static interface ChatCompletions {
        default public CompletableFuture<ChatResponse> create(@Body ChatRequest chatRequest) {
            ChatRequest request = OpenAI.updateRequest(chatRequest, Boolean.FALSE);
            return this.createRoot(request);
        }

        @POST
        public CompletableFuture<ChatResponse> createRoot(@Body ChatRequest var1);

        default public CompletableFuture<Stream<ChatResponse>> createStream(@Body ChatRequest chatRequest) {
            ChatRequest request = OpenAI.updateRequest(chatRequest, Boolean.TRUE);
            return this.createStreamRoot(request);
        }

        @POST
        public CompletableFuture<Stream<ChatResponse>> createStreamRoot(@Body ChatRequest var1);
    }

    @Resource(value="/v1/batches")
    public static interface Batches {
        @POST
        public CompletableFuture<BatchResponse> create(@Body BatchRequest var1);

        @GET(value="/{batchId}")
        public CompletableFuture<BatchResponse> getOne(@Path(value="batchId") String var1);

        @POST(value="/{batchId}/cancel")
        public CompletableFuture<BatchResponse> cancel(@Path(value="batchId") String var1);

        @GET
        public CompletableFuture<Page<BatchResponse>> getList(@Query(value="after") String var1, @Query(value="limit") Integer var2);
    }

    @Resource(value="/v1/audio")
    public static interface Audios {
        @POST(value="/speech")
        public CompletableFuture<InputStream> speak(@Body AudioSpeechRequest var1);

        default public CompletableFuture<AudioResponse> transcribe(AudioTranscribeRequest audioRequest) {
            AudioRespFmt responseFormat = OpenAI.getResponseFormat(audioRequest.getResponseFormat(), AudioRespFmt.JSON, "transcribe");
            AudioTranscribeRequest request = audioRequest.withResponseFormat(responseFormat);
            return this.transcribeRoot(request);
        }

        @Multipart
        @POST(value="/transcriptions")
        public CompletableFuture<AudioResponse> transcribeRoot(@Body AudioTranscribeRequest var1);

        default public CompletableFuture<AudioResponse> translate(AudioTranslateRequest audioRequest) {
            AudioRespFmt responseFormat = OpenAI.getResponseFormat(audioRequest.getResponseFormat(), AudioRespFmt.JSON, "translate");
            AudioTranslateRequest request = audioRequest.withResponseFormat(responseFormat);
            return this.translateRoot(request);
        }

        @Multipart
        @POST(value="/translations")
        public CompletableFuture<AudioResponse> translateRoot(@Body AudioTranslateRequest var1);

        default public CompletableFuture<String> transcribePlain(AudioTranscribeRequest audioRequest) {
            AudioRespFmt responseFormat = OpenAI.getResponseFormat(audioRequest.getResponseFormat(), AudioRespFmt.TEXT, "transcribe");
            AudioTranscribeRequest request = audioRequest.withResponseFormat(responseFormat);
            return this.transcribePlainRoot(request);
        }

        @Multipart
        @POST(value="/transcriptions")
        public CompletableFuture<String> transcribePlainRoot(@Body AudioTranscribeRequest var1);

        default public CompletableFuture<String> translatePlain(AudioTranslateRequest audioRequest) {
            AudioRespFmt responseFormat = OpenAI.getResponseFormat(audioRequest.getResponseFormat(), AudioRespFmt.TEXT, "translate");
            AudioTranslateRequest request = audioRequest.withResponseFormat(responseFormat);
            return this.translatePlainRoot(request);
        }

        @Multipart
        @POST(value="/translations")
        public CompletableFuture<String> translatePlainRoot(@Body AudioTranslateRequest var1);
    }
}

