/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.assistant;

import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.openai.domain.assistant.ToolOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;

@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class ToolOutputSubmission {
    @NonNull
    private List<ToolOutput> toolOutputs;

    ToolOutputSubmission(@NonNull List<ToolOutput> toolOutputs) {
        if (toolOutputs == null) {
            throw new NullPointerException("toolOutputs is marked non-null but is null");
        }
        this.toolOutputs = toolOutputs;
    }

    public static ToolOutputSubmissionBuilder builder() {
        return new ToolOutputSubmissionBuilder();
    }

    @NonNull
    public List<ToolOutput> getToolOutputs() {
        return this.toolOutputs;
    }

    public static class ToolOutputSubmissionBuilder {
        private ArrayList<ToolOutput> toolOutputs;

        ToolOutputSubmissionBuilder() {
        }

        public ToolOutputSubmissionBuilder toolOutput(ToolOutput toolOutput) {
            if (this.toolOutputs == null) {
                this.toolOutputs = new ArrayList();
            }
            this.toolOutputs.add(toolOutput);
            return this;
        }

        public ToolOutputSubmissionBuilder toolOutputs(Collection<? extends ToolOutput> toolOutputs) {
            if (toolOutputs == null) {
                throw new NullPointerException("toolOutputs cannot be null");
            }
            if (this.toolOutputs == null) {
                this.toolOutputs = new ArrayList();
            }
            this.toolOutputs.addAll(toolOutputs);
            return this;
        }

        public ToolOutputSubmissionBuilder clearToolOutputs() {
            if (this.toolOutputs != null) {
                this.toolOutputs.clear();
            }
            return this;
        }

        public ToolOutputSubmission build() {
            List<ToolOutput> toolOutputs;
            switch (this.toolOutputs == null ? 0 : this.toolOutputs.size()) {
                case 0: {
                    toolOutputs = Collections.emptyList();
                    break;
                }
                case 1: {
                    toolOutputs = Collections.singletonList(this.toolOutputs.get(0));
                    break;
                }
                default: {
                    toolOutputs = Collections.unmodifiableList(new ArrayList<ToolOutput>(this.toolOutputs));
                }
            }
            return new ToolOutputSubmission(toolOutputs);
        }

        public String toString() {
            return "ToolOutputSubmission.ToolOutputSubmissionBuilder(toolOutputs=" + this.toolOutputs + ")";
        }
    }
}

