/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain;

import com.fasterxml.jackson.annotation.JsonInclude;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class PageRequest {
    private Integer limit;
    private Order order;
    private String after;
    private String before;

    PageRequest(Integer limit, Order order, String after, String before) {
        this.limit = limit;
        this.order = order;
        this.after = after;
        this.before = before;
    }

    public static PageRequestBuilder builder() {
        return new PageRequestBuilder();
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Order getOrder() {
        return this.order;
    }

    public String getAfter() {
        return this.after;
    }

    public String getBefore() {
        return this.before;
    }

    public static class PageRequestBuilder {
        private Integer limit;
        private Order order;
        private String after;
        private String before;

        PageRequestBuilder() {
        }

        public PageRequestBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public PageRequestBuilder order(Order order) {
            this.order = order;
            return this;
        }

        public PageRequestBuilder after(String after) {
            this.after = after;
            return this;
        }

        public PageRequestBuilder before(String before) {
            this.before = before;
            return this;
        }

        public PageRequest build() {
            return new PageRequest(this.limit, this.order, this.after, this.before);
        }

        public String toString() {
            return "PageRequest.PageRequestBuilder(limit=" + this.limit + ", order=" + this.order + ", after=" + this.after + ", before=" + this.before + ")";
        }
    }

    public static enum Order {
        ASC,
        DESC;

    }
}

