/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.support;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.Option;
import com.github.victools.jsonschema.generator.OptionPreset;
import com.github.victools.jsonschema.generator.SchemaGenerator;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaVersion;
import com.github.victools.jsonschema.module.jackson.JacksonModule;
import com.github.victools.jsonschema.module.jackson.JacksonOption;
import io.github.sashirestela.openai.SimpleUncheckedException;
import java.lang.reflect.Type;

public class JsonSchemaUtil {
    private static ObjectMapper objectMapper = new ObjectMapper();

    private JsonSchemaUtil() {
    }

    public static JsonNode classToJsonSchema(Class<?> clazz) {
        JsonNode jsonSchema = null;
        if (clazz.getFields().length > 0) {
            try {
                JacksonModule jacksonModule = new JacksonModule(new JacksonOption[]{JacksonOption.RESPECT_JSONPROPERTY_REQUIRED});
                SchemaGeneratorConfigBuilder configBuilder = new SchemaGeneratorConfigBuilder(SchemaVersion.DRAFT_2020_12, OptionPreset.PLAIN_JSON).with((Module)jacksonModule).without(Option.SCHEMA_VERSION_INDICATOR, new Option[0]);
                SchemaGeneratorConfig config = configBuilder.build();
                SchemaGenerator generator = new SchemaGenerator(config);
                jsonSchema = generator.generateSchema(clazz, new Type[0]);
            }
            catch (Exception e) {
                throw new SimpleUncheckedException("Cannot generate the Json Schema for the class {0}.", clazz.getName(), e);
            }
        }
        try {
            jsonSchema = objectMapper.readTree("{\"type\":\"object\",\"properties\":{}}");
        }
        catch (JsonProcessingException e) {
            throw new SimpleUncheckedException("Cannot generate the Json Schema for the class {0}.", new Object[]{clazz.getName(), e});
        }
        return jsonSchema;
    }
}

