/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.file;

import java.nio.file.Path;
import lombok.NonNull;

public class FileRequest {
    @NonNull
    private Path file;
    @NonNull
    private String purpose;

    FileRequest(@NonNull Path file, @NonNull String purpose) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (purpose == null) {
            throw new NullPointerException("purpose is marked non-null but is null");
        }
        this.file = file;
        this.purpose = purpose;
    }

    public static FileRequestBuilder builder() {
        return new FileRequestBuilder();
    }

    @NonNull
    public Path getFile() {
        return this.file;
    }

    @NonNull
    public String getPurpose() {
        return this.purpose;
    }

    public static class FileRequestBuilder {
        private Path file;
        private String purpose;

        FileRequestBuilder() {
        }

        public FileRequestBuilder file(@NonNull Path file) {
            if (file == null) {
                throw new NullPointerException("file is marked non-null but is null");
            }
            this.file = file;
            return this;
        }

        public FileRequestBuilder purpose(@NonNull String purpose) {
            if (purpose == null) {
                throw new NullPointerException("purpose is marked non-null but is null");
            }
            this.purpose = purpose;
            return this;
        }

        public FileRequest build() {
            return new FileRequest(this.file, this.purpose);
        }

        public String toString() {
            return "FileRequest.FileRequestBuilder(file=" + this.file + ", purpose=" + this.purpose + ")";
        }
    }
}

