/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.embedding;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import lombok.NonNull;

public class EmbeddingRequest {
    @NonNull
    private String model;
    @NonNull
    private List<String> input;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String user;

    EmbeddingRequest(@NonNull String model, @NonNull List<String> input, String user) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        this.model = model;
        this.input = input;
        this.user = user;
    }

    public static EmbeddingRequestBuilder builder() {
        return new EmbeddingRequestBuilder();
    }

    @NonNull
    public String getModel() {
        return this.model;
    }

    @NonNull
    public List<String> getInput() {
        return this.input;
    }

    public String getUser() {
        return this.user;
    }

    public static class EmbeddingRequestBuilder {
        private String model;
        private List<String> input;
        private String user;

        EmbeddingRequestBuilder() {
        }

        public EmbeddingRequestBuilder model(@NonNull String model) {
            if (model == null) {
                throw new NullPointerException("model is marked non-null but is null");
            }
            this.model = model;
            return this;
        }

        public EmbeddingRequestBuilder input(@NonNull List<String> input) {
            if (input == null) {
                throw new NullPointerException("input is marked non-null but is null");
            }
            this.input = input;
            return this;
        }

        public EmbeddingRequestBuilder user(String user) {
            this.user = user;
            return this;
        }

        public EmbeddingRequest build() {
            return new EmbeddingRequest(this.model, this.input, this.user);
        }

        public String toString() {
            return "EmbeddingRequest.EmbeddingRequestBuilder(model=" + this.model + ", input=" + this.input + ", user=" + this.user + ")";
        }
    }
}

