/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.audio;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.sashirestela.openai.domain.audio.AudioRespFmt;
import java.nio.file.Path;
import lombok.NonNull;

public class AudioTranslateRequest {
    @NonNull
    protected Path file;
    @NonNull
    protected String model;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected String prompt;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="response_format")
    protected AudioRespFmt responseFormat;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected Double temperature;

    public void setResponseFormat(AudioRespFmt responseFormat) {
        this.responseFormat = responseFormat;
    }

    protected AudioTranslateRequest(AudioTranslateRequestBuilder<?, ?> b) {
        this.file = b.file;
        if (this.file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        this.model = b.model;
        if (this.model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        this.prompt = b.prompt;
        this.responseFormat = b.responseFormat;
        this.temperature = b.temperature;
    }

    public static AudioTranslateRequestBuilder<?, ?> builder() {
        return new AudioTranslateRequestBuilderImpl();
    }

    @NonNull
    public Path getFile() {
        return this.file;
    }

    @NonNull
    public String getModel() {
        return this.model;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public AudioRespFmt getResponseFormat() {
        return this.responseFormat;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    private static final class AudioTranslateRequestBuilderImpl
    extends AudioTranslateRequestBuilder<AudioTranslateRequest, AudioTranslateRequestBuilderImpl> {
        private AudioTranslateRequestBuilderImpl() {
        }

        @Override
        protected AudioTranslateRequestBuilderImpl self() {
            return this;
        }

        @Override
        public AudioTranslateRequest build() {
            return new AudioTranslateRequest(this);
        }
    }

    public static abstract class AudioTranslateRequestBuilder<C extends AudioTranslateRequest, B extends AudioTranslateRequestBuilder<C, B>> {
        private Path file;
        private String model;
        private String prompt;
        private AudioRespFmt responseFormat;
        private Double temperature;

        public B file(@NonNull Path file) {
            if (file == null) {
                throw new NullPointerException("file is marked non-null but is null");
            }
            this.file = file;
            return this.self();
        }

        public B model(@NonNull String model) {
            if (model == null) {
                throw new NullPointerException("model is marked non-null but is null");
            }
            this.model = model;
            return this.self();
        }

        public B prompt(String prompt) {
            this.prompt = prompt;
            return this.self();
        }

        @JsonProperty(value="response_format")
        public B responseFormat(AudioRespFmt responseFormat) {
            this.responseFormat = responseFormat;
            return this.self();
        }

        public B temperature(Double temperature) {
            this.temperature = temperature;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "AudioTranslateRequest.AudioTranslateRequestBuilder(file=" + this.file + ", model=" + this.model + ", prompt=" + this.prompt + ", responseFormat=" + this.responseFormat + ", temperature=" + this.temperature + ")";
        }
    }
}

