/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai;

import io.github.sashirestela.cleverclient.annotation.Body;
import io.github.sashirestela.cleverclient.annotation.DELETE;
import io.github.sashirestela.cleverclient.annotation.GET;
import io.github.sashirestela.cleverclient.annotation.Multipart;
import io.github.sashirestela.cleverclient.annotation.POST;
import io.github.sashirestela.cleverclient.annotation.Path;
import io.github.sashirestela.cleverclient.annotation.Query;
import io.github.sashirestela.cleverclient.annotation.Resource;
import io.github.sashirestela.openai.SimpleUncheckedException;
import io.github.sashirestela.openai.domain.OpenAIDeletedResponse;
import io.github.sashirestela.openai.domain.OpenAIGeneric;
import io.github.sashirestela.openai.domain.audio.AudioRespFmt;
import io.github.sashirestela.openai.domain.audio.AudioResponse;
import io.github.sashirestela.openai.domain.audio.AudioTranscribeRequest;
import io.github.sashirestela.openai.domain.audio.AudioTranslateRequest;
import io.github.sashirestela.openai.domain.chat.ChatRequest;
import io.github.sashirestela.openai.domain.chat.ChatResponse;
import io.github.sashirestela.openai.domain.completion.CompletionRequest;
import io.github.sashirestela.openai.domain.completion.CompletionResponse;
import io.github.sashirestela.openai.domain.embedding.EmbeddingRequest;
import io.github.sashirestela.openai.domain.embedding.EmbeddingResponse;
import io.github.sashirestela.openai.domain.file.FileRequest;
import io.github.sashirestela.openai.domain.file.FileResponse;
import io.github.sashirestela.openai.domain.finetuning.FineTuningEvent;
import io.github.sashirestela.openai.domain.finetuning.FineTuningRequest;
import io.github.sashirestela.openai.domain.finetuning.FineTuningResponse;
import io.github.sashirestela.openai.domain.image.ImageEditsRequest;
import io.github.sashirestela.openai.domain.image.ImageRequest;
import io.github.sashirestela.openai.domain.image.ImageResponse;
import io.github.sashirestela.openai.domain.image.ImageVariationsRequest;
import io.github.sashirestela.openai.domain.model.ModelResponse;
import io.github.sashirestela.openai.domain.moderation.ModerationRequest;
import io.github.sashirestela.openai.domain.moderation.ModerationResponse;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;

interface OpenAI {

    @Resource(value="/v1/moderations")
    public static interface Moderations {
        @POST
        public CompletableFuture<ModerationResponse> create(@Body ModerationRequest var1);
    }

    @Resource(value="/v1/models")
    public static interface Models {
        default public CompletableFuture<List<ModelResponse>> getList() {
            return this.notUseGetGenericModel().thenApply(OpenAIGeneric::getData);
        }

        @GET
        public CompletableFuture<OpenAIGeneric<ModelResponse>> notUseGetGenericModel();

        @GET(value="/{modelId}")
        public CompletableFuture<ModelResponse> getOne(@Path(value="modelId") String var1);

        @DELETE(value="/{modelId}")
        public CompletableFuture<OpenAIDeletedResponse> delete(@Path(value="modelId") String var1);
    }

    @Resource(value="/v1/images")
    public static interface Images {
        default public CompletableFuture<List<ImageResponse>> create(ImageRequest imageRequest) {
            return this.notUseCreate(imageRequest).thenApply(OpenAIGeneric::getData);
        }

        @POST(value="/generations")
        public CompletableFuture<OpenAIGeneric<ImageResponse>> notUseCreate(@Body ImageRequest var1);

        default public CompletableFuture<List<ImageResponse>> createEdits(ImageEditsRequest imageRequest) {
            return this.notUseCreateEdits(imageRequest).thenApply(OpenAIGeneric::getData);
        }

        @Multipart
        @POST(value="/edits")
        public CompletableFuture<OpenAIGeneric<ImageResponse>> notUseCreateEdits(@Body ImageEditsRequest var1);

        default public CompletableFuture<List<ImageResponse>> createVariations(ImageVariationsRequest imageRequest) {
            return this.notUseCreateVariations(imageRequest).thenApply(OpenAIGeneric::getData);
        }

        @Multipart
        @POST(value="/variations")
        public CompletableFuture<OpenAIGeneric<ImageResponse>> notUseCreateVariations(@Body ImageVariationsRequest var1);
    }

    @Resource(value="/v1/fine_tuning/jobs")
    public static interface FineTunings {
        @POST
        public CompletableFuture<FineTuningResponse> create(@Body FineTuningRequest var1);

        default public CompletableFuture<List<FineTuningResponse>> getList(Integer limit, String after) {
            return this.notUseGetGenericFineTuning(limit, after).thenApply(OpenAIGeneric::getData);
        }

        @GET
        public CompletableFuture<OpenAIGeneric<FineTuningResponse>> notUseGetGenericFineTuning(@Query(value="limit") Integer var1, @Query(value="after") String var2);

        @GET(value="/{fineTuningId}")
        public CompletableFuture<FineTuningResponse> getOne(@Path(value="fineTuningId") String var1);

        default public CompletableFuture<List<FineTuningEvent>> getEvents(String fineTuningId, Integer limit, String after) {
            return this.notUseGetGenericFineTuningEvent(fineTuningId, limit, after).thenApply(OpenAIGeneric::getData);
        }

        @GET(value="/{fineTuningId}/events")
        public CompletableFuture<OpenAIGeneric<FineTuningEvent>> notUseGetGenericFineTuningEvent(@Path(value="fineTuningId") String var1, @Query(value="limit") Integer var2, @Query(value="after") String var3);

        @POST(value="/{fineTuningId}/cancel")
        public CompletableFuture<FineTuningResponse> cancel(@Path(value="fineTuningId") String var1);
    }

    @Resource(value="/v1/files")
    public static interface Files {
        @Multipart
        @POST
        public CompletableFuture<FileResponse> create(@Body FileRequest var1);

        default public CompletableFuture<List<FileResponse>> getList() {
            return this.notUseGetGenericFile().thenApply(OpenAIGeneric::getData);
        }

        @GET
        public CompletableFuture<OpenAIGeneric<FileResponse>> notUseGetGenericFile();

        @GET(value="/{fileId}")
        public CompletableFuture<FileResponse> getOne(@Path(value="fileId") String var1);

        @GET(value="/{fileId}/content")
        public CompletableFuture<String> getContent(@Path(value="fileId") String var1);

        @DELETE(value="/{fileId}")
        public CompletableFuture<OpenAIDeletedResponse> delete(@Path(value="fileId") String var1);
    }

    @Resource(value="/v1/embeddings")
    public static interface Embeddings {
        @POST
        public CompletableFuture<EmbeddingResponse> create(@Body EmbeddingRequest var1);
    }

    @Resource(value="/v1/completions")
    public static interface Completions {
        default public CompletableFuture<CompletionResponse> create(CompletionRequest completionRequest) {
            completionRequest.setStream(false);
            return this.notUseCreate(completionRequest);
        }

        @POST
        public CompletableFuture<CompletionResponse> notUseCreate(@Body CompletionRequest var1);

        default public CompletableFuture<Stream<CompletionResponse>> createStream(CompletionRequest completionRequest) {
            completionRequest.setStream(true);
            return this.notUseCreateStream(completionRequest);
        }

        @POST
        public CompletableFuture<Stream<CompletionResponse>> notUseCreateStream(@Body CompletionRequest var1);
    }

    @Resource(value="/v1/chat/completions")
    public static interface ChatCompletions {
        default public CompletableFuture<ChatResponse> create(ChatRequest chatRequest) {
            chatRequest.setStream(false);
            return this.notUseCreate(chatRequest);
        }

        @POST
        public CompletableFuture<ChatResponse> notUseCreate(@Body ChatRequest var1);

        default public CompletableFuture<Stream<ChatResponse>> createStream(ChatRequest chatRequest) {
            chatRequest.setStream(true);
            return this.notUseCreateStream(chatRequest);
        }

        @POST
        public CompletableFuture<Stream<ChatResponse>> notUseCreateStream(@Body ChatRequest var1);
    }

    @Resource(value="/v1/audio")
    public static interface Audios {
        private void setResponseFormatIfApplyOrThrownException(Object audioRequest, boolean isText, String methodName) {
            EnumSet<AudioRespFmt> jsonEnumSet = EnumSet.of(AudioRespFmt.JSON, AudioRespFmt.VERBOSE_JSON);
            EnumSet<AudioRespFmt> textEnumSet = EnumSet.complementOf(jsonEnumSet);
            AudioTranslateRequest requestObj = (AudioTranslateRequest)audioRequest;
            AudioRespFmt responseFormat = requestObj.getResponseFormat();
            if (isText) {
                if (responseFormat != null) {
                    if (!textEnumSet.contains((Object)responseFormat)) {
                        throw new SimpleUncheckedException("Unexpected responseFormat for the method {0}.", methodName, null);
                    }
                } else {
                    requestObj.setResponseFormat(AudioRespFmt.TEXT);
                }
            } else if (responseFormat != null) {
                if (!jsonEnumSet.contains((Object)responseFormat)) {
                    throw new SimpleUncheckedException("Unexpected responseFormat for the method {0}.", methodName, null);
                }
            } else {
                requestObj.setResponseFormat(AudioRespFmt.JSON);
            }
        }

        default public CompletableFuture<AudioResponse> transcribe(AudioTranscribeRequest audioRequest) {
            this.setResponseFormatIfApplyOrThrownException(audioRequest, false, "transcribe");
            return this.notUseTranscribe(audioRequest);
        }

        @Multipart
        @POST(value="/transcriptions")
        public CompletableFuture<AudioResponse> notUseTranscribe(@Body AudioTranscribeRequest var1);

        default public CompletableFuture<AudioResponse> translate(AudioTranslateRequest audioRequest) {
            this.setResponseFormatIfApplyOrThrownException(audioRequest, false, "translate");
            return this.notUseTranslate(audioRequest);
        }

        @Multipart
        @POST(value="/translations")
        public CompletableFuture<AudioResponse> notUseTranslate(@Body AudioTranslateRequest var1);

        default public CompletableFuture<String> transcribePlain(AudioTranscribeRequest audioRequest) {
            this.setResponseFormatIfApplyOrThrownException(audioRequest, true, "transcribePlain");
            return this.notUseTranscribePlain(audioRequest);
        }

        @Multipart
        @POST(value="/transcriptions")
        public CompletableFuture<String> notUseTranscribePlain(@Body AudioTranscribeRequest var1);

        default public CompletableFuture<String> translatePlain(AudioTranslateRequest audioRequest) {
            this.setResponseFormatIfApplyOrThrownException(audioRequest, true, "translatePlain");
            return this.notUseTranslatePlain(audioRequest);
        }

        @Multipart
        @POST(value="/translations")
        public CompletableFuture<String> notUseTranslatePlain(@Body AudioTranslateRequest var1);
    }
}

