/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.cleverclient.client;

import io.github.sashirestela.cleverclient.http.HttpRequestData;
import io.github.sashirestela.cleverclient.support.ContentType;
import io.github.sashirestela.cleverclient.support.ReturnType;
import io.github.sashirestela.cleverclient.util.CommonUtil;
import java.util.List;
import lombok.Generated;

public class RequestData {
    private final String url;
    private final Object body;
    private final List<String> headers;
    private final String httpMethod;
    private final ContentType contentType;
    private final ReturnType returnType;

    public HttpRequestData getHttpRequestData() {
        return HttpRequestData.builder().url(this.url).body(this.body).headers(CommonUtil.listToMapOfString(this.headers)).contentType(this.contentType).httpMethod(this.httpMethod).build();
    }

    @Generated
    public static RequestDataBuilder builder() {
        return new RequestDataBuilder();
    }

    @Generated
    public RequestData(String url, Object body, List<String> headers, String httpMethod, ContentType contentType, ReturnType returnType) {
        this.url = url;
        this.body = body;
        this.headers = headers;
        this.httpMethod = httpMethod;
        this.contentType = contentType;
        this.returnType = returnType;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public Object getBody() {
        return this.body;
    }

    @Generated
    public List<String> getHeaders() {
        return this.headers;
    }

    @Generated
    public String getHttpMethod() {
        return this.httpMethod;
    }

    @Generated
    public ContentType getContentType() {
        return this.contentType;
    }

    @Generated
    public ReturnType getReturnType() {
        return this.returnType;
    }

    @Generated
    public RequestData withUrl(String url) {
        return this.url == url ? this : new RequestData(url, this.body, this.headers, this.httpMethod, this.contentType, this.returnType);
    }

    @Generated
    public RequestData withBody(Object body) {
        return this.body == body ? this : new RequestData(this.url, body, this.headers, this.httpMethod, this.contentType, this.returnType);
    }

    @Generated
    public RequestData withHeaders(List<String> headers) {
        return this.headers == headers ? this : new RequestData(this.url, this.body, headers, this.httpMethod, this.contentType, this.returnType);
    }

    @Generated
    public static class RequestDataBuilder {
        @Generated
        private String url;
        @Generated
        private Object body;
        @Generated
        private List<String> headers;
        @Generated
        private String httpMethod;
        @Generated
        private ContentType contentType;
        @Generated
        private ReturnType returnType;

        @Generated
        RequestDataBuilder() {
        }

        @Generated
        public RequestDataBuilder url(String url) {
            this.url = url;
            return this;
        }

        @Generated
        public RequestDataBuilder body(Object body) {
            this.body = body;
            return this;
        }

        @Generated
        public RequestDataBuilder headers(List<String> headers) {
            this.headers = headers;
            return this;
        }

        @Generated
        public RequestDataBuilder httpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        @Generated
        public RequestDataBuilder contentType(ContentType contentType) {
            this.contentType = contentType;
            return this;
        }

        @Generated
        public RequestDataBuilder returnType(ReturnType returnType) {
            this.returnType = returnType;
            return this;
        }

        @Generated
        public RequestData build() {
            return new RequestData(this.url, this.body, this.headers, this.httpMethod, this.contentType, this.returnType);
        }

        @Generated
        public String toString() {
            return "RequestData.RequestDataBuilder(url=" + this.url + ", body=" + String.valueOf(this.body) + ", headers=" + String.valueOf(this.headers) + ", httpMethod=" + this.httpMethod + ", contentType=" + String.valueOf((Object)this.contentType) + ", returnType=" + String.valueOf(this.returnType) + ")";
        }
    }
}

