/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.cleverclient.support;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.sashirestela.cleverclient.support.CleverClientException;
import io.github.sashirestela.cleverclient.util.JsonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

public class Configurator {
    private static Configurator configurator = new Configurator();
    private List<String> endsOfStream;
    private ObjectMapper objectMapper;
    private boolean wasBuilt = false;

    private Configurator() {
    }

    public Configurator(List<String> endsOfStream, ObjectMapper objectMapper) {
        if (Configurator.configurator.wasBuilt) {
            return;
        }
        Configurator.configurator.endsOfStream = endsOfStream;
        Configurator.configurator.objectMapper = objectMapper;
        JsonUtil.updateObjectMapper(objectMapper);
        Configurator.configurator.wasBuilt = true;
    }

    public static Configurator one() {
        if (!Configurator.configurator.wasBuilt) {
            throw new CleverClientException("You have to call Configurator.builder() first.");
        }
        return configurator;
    }

    public static void reset() {
        Configurator.configurator.wasBuilt = false;
    }

    @Generated
    public static ConfiguratorBuilder builder() {
        return new ConfiguratorBuilder();
    }

    @Generated
    public List<String> getEndsOfStream() {
        return this.endsOfStream;
    }

    @Generated
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Generated
    public static class ConfiguratorBuilder {
        @Generated
        private ArrayList<String> endsOfStream;
        @Generated
        private ObjectMapper objectMapper;

        @Generated
        ConfiguratorBuilder() {
        }

        @Generated
        public ConfiguratorBuilder endOfStream(String endOfStream) {
            if (this.endsOfStream == null) {
                this.endsOfStream = new ArrayList();
            }
            this.endsOfStream.add(endOfStream);
            return this;
        }

        @Generated
        public ConfiguratorBuilder endsOfStream(Collection<? extends String> endsOfStream) {
            if (endsOfStream == null) {
                throw new NullPointerException("endsOfStream cannot be null");
            }
            if (this.endsOfStream == null) {
                this.endsOfStream = new ArrayList();
            }
            this.endsOfStream.addAll(endsOfStream);
            return this;
        }

        @Generated
        public ConfiguratorBuilder clearEndsOfStream() {
            if (this.endsOfStream != null) {
                this.endsOfStream.clear();
            }
            return this;
        }

        @Generated
        public ConfiguratorBuilder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        @Generated
        public Configurator build() {
            List<String> endsOfStream;
            switch (this.endsOfStream == null ? 0 : this.endsOfStream.size()) {
                case 0: {
                    endsOfStream = Collections.emptyList();
                    break;
                }
                case 1: {
                    endsOfStream = Collections.singletonList(this.endsOfStream.get(0));
                    break;
                }
                default: {
                    endsOfStream = Collections.unmodifiableList(new ArrayList<String>(this.endsOfStream));
                }
            }
            return new Configurator(endsOfStream, this.objectMapper);
        }

        @Generated
        public String toString() {
            return "Configurator.ConfiguratorBuilder(endsOfStream=" + this.endsOfStream + ", objectMapper=" + this.objectMapper + ")";
        }
    }
}

