/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.cleverclient.websocket;

import io.github.sashirestela.cleverclient.support.CleverClientException;
import io.github.sashirestela.cleverclient.websocket.WebSocketAdapter;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpWebSocketAdapter
extends WebSocketAdapter {
    private static final Logger logger = LoggerFactory.getLogger(OkHttpWebSocketAdapter.class);
    private OkHttpClient okHttpClient;
    private WebSocket webSocket;

    public OkHttpWebSocketAdapter(OkHttpClient okHttpClient) {
        this.okHttpClient = okHttpClient;
        logger.debug("Created OkHttpWebSocketAdapter");
    }

    public OkHttpWebSocketAdapter() {
        this(new OkHttpClient());
    }

    @Override
    public CompletableFuture<Void> connect(String url, Map<String, String> headers) {
        logger.debug("Connecting to WebSocket URL: {}", (Object)url);
        logger.debug("Connection headers: {}", headers);
        Request.Builder requestBuilder = new Request.Builder().url(url);
        headers.forEach((arg_0, arg_1) -> ((Request.Builder)requestBuilder).addHeader(arg_0, arg_1));
        final CompletableFuture<Void> connectFuture = new CompletableFuture<Void>();
        this.webSocket = this.okHttpClient.newWebSocket(requestBuilder.build(), new WebSocketListener(){

            public void onOpen(WebSocket webSocket, Response response) {
                logger.debug("WebSocket connection established with response code: {}", (Object)response.code());
                if (OkHttpWebSocketAdapter.this.openCallback != null) {
                    OkHttpWebSocketAdapter.this.openCallback.execute();
                }
                connectFuture.complete(null);
            }

            public void onMessage(WebSocket webSocket, String text) {
                logger.debug("Received message: {}", (Object)text);
                if (OkHttpWebSocketAdapter.this.messageCallback != null) {
                    OkHttpWebSocketAdapter.this.messageCallback.accept(text);
                }
            }

            public void onClosing(WebSocket webSocket, int code, String reason) {
                logger.debug("WebSocket closing with code: {}, reason: {}", (Object)code, (Object)reason);
                if (OkHttpWebSocketAdapter.this.closeCallback != null) {
                    OkHttpWebSocketAdapter.this.closeCallback.accept(code, reason);
                }
            }

            public void onFailure(WebSocket webSocket, Throwable t, Response response) {
                String responseCode = response != null ? String.valueOf(response.code()) : "unknown";
                logger.error("WebSocket error occurred. Response code: {}", (Object)responseCode, (Object)t);
                if (OkHttpWebSocketAdapter.this.errorCallback != null) {
                    OkHttpWebSocketAdapter.this.errorCallback.accept(t);
                }
                connectFuture.completeExceptionally(t);
            }
        });
        return connectFuture;
    }

    @Override
    public CompletableFuture<Void> send(String message) {
        logger.debug("Sending message: {}", (Object)message);
        boolean success = this.webSocket.send(message);
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (success) {
            logger.trace("Message sent successfully");
            future.complete(null);
        } else {
            String errorMsg = "Failed to send message";
            logger.error(errorMsg);
            future.completeExceptionally(new CleverClientException(errorMsg));
        }
        return future;
    }

    @Override
    public void close() {
        if (this.webSocket != null) {
            logger.debug("Initiating WebSocket close");
            this.webSocket.close(1000, "Closing connection");
            this.okHttpClient.dispatcher().executorService().shutdown();
            this.okHttpClient.connectionPool().evictAll();
            logger.debug("WebSocket resources cleaned up");
        }
    }
}

