/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.cleverclient.sender;

import io.github.sashirestela.cleverclient.ResponseInfo;
import io.github.sashirestela.cleverclient.support.CleverClientException;
import io.github.sashirestela.cleverclient.support.ReturnType;
import io.github.sashirestela.cleverclient.util.CommonUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpSender {
    protected static Logger logger = LoggerFactory.getLogger(HttpSender.class);

    public abstract Object sendRequest(HttpClient var1, HttpRequest var2, ReturnType var3);

    protected void throwExceptionIfErrorIsPresent(HttpResponse<?> response, Class<?> clazz) {
        logger.debug("Response Code : {}", (Object)response.statusCode());
        if (!CommonUtil.isInHundredsOf(response.statusCode(), 200)) {
            String data = "";
            if (Stream.class.equals(clazz)) {
                data = ((Stream)response.body()).collect(Collectors.joining(System.getProperty("line.separator")));
            } else if (InputStream.class.equals(clazz)) {
                try {
                    data = new String(((InputStream)response.body()).readAllBytes(), StandardCharsets.UTF_8);
                }
                catch (IOException e) {
                    throw new CleverClientException(e);
                }
            } else {
                data = (String)response.body();
            }
            logger.error("Response : {}", (Object)data);
            throw new CleverClientException(this.fillResponseInfo(response, data));
        }
    }

    private ResponseInfo fillResponseInfo(HttpResponse<?> response, String data) {
        HttpRequest request = response.request();
        return ResponseInfo.builder().statusCode(response.statusCode()).data(data).headers(response.headers().map()).request(ResponseInfo.RequestInfo.builder().httpMethod(request.method()).url(request.uri().toString()).headers(request.headers().map()).build()).build();
    }
}

