/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.cleverclient.http;

import io.github.sashirestela.cleverclient.annotation.Body;
import io.github.sashirestela.cleverclient.annotation.BodyPart;
import io.github.sashirestela.cleverclient.annotation.Path;
import io.github.sashirestela.cleverclient.http.HttpConnector;
import io.github.sashirestela.cleverclient.http.HttpInvocationHandler;
import io.github.sashirestela.cleverclient.http.ReturnType;
import io.github.sashirestela.cleverclient.http.URLBuilder;
import io.github.sashirestela.cleverclient.metadata.Metadata;
import io.github.sashirestela.cleverclient.metadata.MetadataCollector;
import io.github.sashirestela.cleverclient.support.CleverClientException;
import io.github.sashirestela.cleverclient.util.CommonUtil;
import io.github.sashirestela.cleverclient.util.Constant;
import io.github.sashirestela.cleverclient.util.ReflectUtil;
import java.lang.reflect.Method;
import java.net.http.HttpClient;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpProcessor {
    private static Logger logger = LoggerFactory.getLogger(HttpProcessor.class);
    private HttpClient httpClient;
    private String urlBase;
    private List<String> headers;
    private Metadata metadata;
    private URLBuilder urlBuilder;

    public HttpProcessor(HttpClient httpClient, String urlBase, List<String> headers) {
        this.httpClient = httpClient;
        this.urlBase = urlBase;
        this.headers = Optional.ofNullable(headers).orElse(List.of());
    }

    public <T> T createProxy(Class<T> interfaceClass) {
        this.metadata = MetadataCollector.collect(interfaceClass);
        this.validateMetadata();
        this.urlBuilder = new URLBuilder(this.metadata);
        HttpInvocationHandler httpInvocationHandler = new HttpInvocationHandler(this);
        T proxy = ReflectUtil.createProxy(interfaceClass, httpInvocationHandler);
        logger.debug("Created Instance : {}", (Object)interfaceClass.getSimpleName());
        return proxy;
    }

    public Object resolve(Method method, Object[] arguments) {
        String methodName = method.getName();
        Metadata.Method methodMetadata = this.metadata.getMethods().get(methodName);
        String url = this.urlBase + this.urlBuilder.build(methodName, arguments);
        String httpMethod = methodMetadata.getHttpAnnotation().getName();
        ReturnType returnType = methodMetadata.getReturnType();
        boolean isMultipart = methodMetadata.isMultipart();
        List<Object> bodyObjects = this.calculateBodyObjects(methodMetadata, arguments);
        ArrayList<String> fullHeaders = new ArrayList<String>(this.headers);
        fullHeaders.addAll(this.calculateHeaderContentType(bodyObjects, isMultipart));
        String[] fullHeadersArray = fullHeaders.toArray(new String[0]);
        HttpConnector httpConnector = HttpConnector.builder().httpClient(this.httpClient).url(url).httpMethod(httpMethod).returnType(returnType).bodyObjects(bodyObjects).isMultipart(isMultipart).headersArray(fullHeadersArray).build();
        logger.debug("Http Call : {} {}", (Object)httpMethod, (Object)url);
        return httpConnector.sendRequest();
    }

    private void validateMetadata() {
        this.metadata.getMethods().forEach((methodName, methodMetadata) -> {
            if (!methodMetadata.isDefault()) {
                Optional.ofNullable(methodMetadata.getHttpAnnotation()).orElseThrow(() -> new CleverClientException("Missing HTTP anotation for the method {0}.", methodName, null));
            }
        });
        String PATH = Path.class.getSimpleName();
        this.metadata.getMethods().forEach((methodName, methodMetadata) -> {
            String url = methodMetadata.getUrl();
            List<String> listPathParams = CommonUtil.findFullMatches(url, "\\{(.*?)\\}");
            if (!CommonUtil.isNullOrEmpty(listPathParams)) {
                listPathParams.forEach(pathParam -> methodMetadata.getParametersByType().get(PATH).stream().filter(paramMetadata -> pathParam.equals(paramMetadata.getAnnotationValue())).findFirst().orElseThrow(() -> new CleverClientException("Path param {0} in the url cannot find an annotated argument in the method {1}.", pathParam, methodName, null)));
            }
        });
    }

    private List<Object> calculateBodyObjects(Metadata.Method methodMetadata, Object[] arguments) {
        String BODY = Body.class.getSimpleName();
        String BODY_PART = BodyPart.class.getSimpleName();
        return Stream.concat(methodMetadata.getParametersByType().get(BODY).stream().limit(1L).map(param -> arguments[param.getIndex()]), methodMetadata.getParametersByType().get(BODY_PART).stream().map(param -> arguments[param.getIndex()]).filter(arg -> !CommonUtil.isNullOrEmpty(arg))).collect(Collectors.toList());
    }

    private List<String> calculateHeaderContentType(List<Object> bodyObjects, boolean isMultipart) {
        ArrayList<String> headerContentType = new ArrayList<String>();
        if (!bodyObjects.isEmpty()) {
            Object contentType = isMultipart ? "multipart/form-data; boundary=\"" + Constant.BOUNDARY_VALUE + "\"" : "application/json";
            headerContentType.add("Content-Type");
            headerContentType.add((String)contentType);
        }
        return headerContentType;
    }
}

