/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.cleverclient.sender;

import io.github.sashirestela.cleverclient.sender.HttpSender;
import io.github.sashirestela.cleverclient.support.CleverClientException;
import io.github.sashirestela.cleverclient.support.CleverClientSSE;
import io.github.sashirestela.cleverclient.util.JsonUtil;
import java.io.IOException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.stream.Stream;

public class HttpSyncStreamSender
extends HttpSender {
    @Override
    public <S, T> Object sendRequest(HttpClient httpClient, HttpRequest httpRequest, Class<T> responseClass, Class<S> genericClass) {
        try {
            HttpResponse<Stream<String>> httpResponse = httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofLines());
            this.throwExceptionIfErrorIsPresent(httpResponse, true);
            return httpResponse.body().peek(rawData -> logger.debug("Response : {}", rawData)).map(CleverClientSSE::new).filter(CleverClientSSE::isActualData).map(event -> JsonUtil.jsonToObject(event.getActualData(), responseClass));
        }
        catch (IOException | InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CleverClientException(e.getMessage(), null, e);
        }
    }
}

