/*
 * Decompiled with CFR 0.152.
 */
package io.github.rupinderjeet.kprogresshud;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.widget.ImageView;
import io.github.rupinderjeet.kprogresshud.Indeterminate;
import io.github.rupinderjeet.kprogresshud.R;

class SpinView
extends ImageView
implements Indeterminate {
    private float mRotateDegrees;
    private int mFrameTime;
    private boolean mNeedToUpdateView;
    private Runnable mUpdateViewRunnable;

    public SpinView(Context context) {
        super(context);
        this.init();
    }

    public SpinView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.setImageResource(R.drawable.kprogresshud_spinner);
        this.mFrameTime = 83;
        this.mUpdateViewRunnable = new Runnable(){

            @Override
            public void run() {
                SpinView.this.mRotateDegrees += 30.0f;
                SpinView.this.mRotateDegrees = SpinView.this.mRotateDegrees < 360.0f ? SpinView.this.mRotateDegrees : SpinView.this.mRotateDegrees - 360.0f;
                SpinView.this.invalidate();
                if (SpinView.this.mNeedToUpdateView) {
                    SpinView.this.postDelayed(this, SpinView.this.mFrameTime);
                }
            }
        };
    }

    @Override
    public void setAnimationSpeed(float scale) {
        this.mFrameTime = (int)(83.0f / scale);
    }

    protected void onDraw(Canvas canvas) {
        canvas.rotate(this.mRotateDegrees, (float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f);
        super.onDraw(canvas);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mNeedToUpdateView = true;
        this.post(this.mUpdateViewRunnable);
    }

    protected void onDetachedFromWindow() {
        this.mNeedToUpdateView = false;
        super.onDetachedFromWindow();
    }
}

