/*
 * Decompiled with CFR 0.152.
 */
package io.github.rupinderjeet.kprogresshud;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.TextView;
import io.github.rupinderjeet.kprogresshud.AnnularView;
import io.github.rupinderjeet.kprogresshud.BackgroundLayout;
import io.github.rupinderjeet.kprogresshud.BarView;
import io.github.rupinderjeet.kprogresshud.Determinate;
import io.github.rupinderjeet.kprogresshud.Helper;
import io.github.rupinderjeet.kprogresshud.Indeterminate;
import io.github.rupinderjeet.kprogresshud.PieView;
import io.github.rupinderjeet.kprogresshud.R;
import io.github.rupinderjeet.kprogresshud.SpinView;

public class KProgressHUD {
    private ProgressDialog mProgressDialog;
    private float mDimAmount;
    private int mWindowColor;
    private float mCornerRadius;
    private Context mContext;
    private int mAnimateSpeed;
    private int mMaxProgress;
    private boolean mIsAutoDismiss;
    private int mGraceTimeMs;
    private Handler mGraceTimer;
    private boolean mFinished;

    public KProgressHUD(Context context) {
        this.mContext = context;
        this.mProgressDialog = new ProgressDialog(context);
        this.mDimAmount = 0.0f;
        this.mWindowColor = context.getResources().getColor(R.color.kprogresshud_default_color);
        this.mAnimateSpeed = 1;
        this.mCornerRadius = 10.0f;
        this.mIsAutoDismiss = true;
        this.mGraceTimeMs = 0;
        this.mFinished = false;
        this.setStyle(Style.SPIN_INDETERMINATE);
    }

    public static KProgressHUD create(Context context) {
        return new KProgressHUD(context);
    }

    public static KProgressHUD create(Context context, Style style) {
        return new KProgressHUD(context).setStyle(style);
    }

    public KProgressHUD setStyle(Style style) {
        Object view = null;
        switch (style) {
            case SPIN_INDETERMINATE: {
                view = new SpinView(this.mContext);
                break;
            }
            case PIE_DETERMINATE: {
                view = new PieView(this.mContext);
                break;
            }
            case ANNULAR_DETERMINATE: {
                view = new AnnularView(this.mContext);
                break;
            }
            case BAR_DETERMINATE: {
                view = new BarView(this.mContext);
            }
        }
        this.mProgressDialog.setView((View)view);
        return this;
    }

    public KProgressHUD setDimAmount(float dimAmount) {
        if (dimAmount >= 0.0f && dimAmount <= 1.0f) {
            this.mDimAmount = dimAmount;
        }
        return this;
    }

    public KProgressHUD setSize(int width, int height) {
        this.mProgressDialog.setSize(width, height);
        return this;
    }

    @Deprecated
    public KProgressHUD setWindowColor(int color2) {
        this.mWindowColor = color2;
        return this;
    }

    public KProgressHUD setBackgroundColor(int color2) {
        this.mWindowColor = color2;
        return this;
    }

    public KProgressHUD setCornerRadius(float radius) {
        this.mCornerRadius = radius;
        return this;
    }

    public KProgressHUD setAnimationSpeed(int scale) {
        this.mAnimateSpeed = scale;
        return this;
    }

    public KProgressHUD setLabel(String label) {
        this.mProgressDialog.setLabel(label);
        return this;
    }

    public KProgressHUD setLabel(String label, int color2) {
        this.mProgressDialog.setLabel(label, color2);
        return this;
    }

    public KProgressHUD setDetailsLabel(String detailsLabel) {
        this.mProgressDialog.setDetailsLabel(detailsLabel);
        return this;
    }

    public KProgressHUD setDetailsLabel(String detailsLabel, int color2) {
        this.mProgressDialog.setDetailsLabel(detailsLabel, color2);
        return this;
    }

    public KProgressHUD setMaxProgress(int maxProgress) {
        this.mMaxProgress = maxProgress;
        return this;
    }

    public void setProgress(int progress) {
        this.mProgressDialog.setProgress(progress);
    }

    public KProgressHUD setCustomView(View view) {
        if (view == null) {
            throw new RuntimeException("Custom view must not be null!");
        }
        this.mProgressDialog.setView(view);
        return this;
    }

    public KProgressHUD setCancellable(boolean isCancellable) {
        this.mProgressDialog.setCancelable(isCancellable);
        this.mProgressDialog.setOnCancelListener(null);
        return this;
    }

    public KProgressHUD setCancellable(DialogInterface.OnCancelListener listener) {
        this.mProgressDialog.setCancelable(null != listener);
        this.mProgressDialog.setOnCancelListener(listener);
        return this;
    }

    public KProgressHUD setAutoDismiss(boolean isAutoDismiss) {
        this.mIsAutoDismiss = isAutoDismiss;
        return this;
    }

    public KProgressHUD setGraceTime(int graceTimeMs) {
        this.mGraceTimeMs = graceTimeMs;
        return this;
    }

    public KProgressHUD show() {
        if (!this.isShowing()) {
            this.mFinished = false;
            if (this.mGraceTimeMs == 0) {
                this.mProgressDialog.show();
            } else {
                this.mGraceTimer = new Handler();
                this.mGraceTimer.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        if (KProgressHUD.this.mProgressDialog != null && !KProgressHUD.this.mFinished) {
                            KProgressHUD.this.mProgressDialog.show();
                        }
                    }
                }, (long)this.mGraceTimeMs);
            }
        }
        return this;
    }

    public boolean isShowing() {
        return this.mProgressDialog != null && this.mProgressDialog.isShowing();
    }

    public void dismiss() {
        this.mFinished = true;
        if (this.mContext != null && this.mProgressDialog != null && this.mProgressDialog.isShowing()) {
            this.mProgressDialog.dismiss();
        }
        if (this.mGraceTimer != null) {
            this.mGraceTimer.removeCallbacksAndMessages(null);
            this.mGraceTimer = null;
        }
    }

    private class ProgressDialog
    extends Dialog {
        private Determinate mDeterminateView;
        private Indeterminate mIndeterminateView;
        private View mView;
        private TextView mLabelText;
        private TextView mDetailsText;
        private String mLabel;
        private String mDetailsLabel;
        private FrameLayout mCustomViewContainer;
        private BackgroundLayout mBackgroundLayout;
        private int mWidth;
        private int mHeight;
        private int mLabelColor;
        private int mDetailColor;

        public ProgressDialog(Context context) {
            super(context);
            this.mLabelColor = -1;
            this.mDetailColor = -1;
        }

        protected void onCreate(Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);
            this.requestWindowFeature(1);
            this.setContentView(R.layout.kprogresshud_hud);
            Window window = this.getWindow();
            window.setBackgroundDrawable((Drawable)new ColorDrawable(0));
            window.addFlags(2);
            WindowManager.LayoutParams layoutParams = window.getAttributes();
            layoutParams.dimAmount = KProgressHUD.this.mDimAmount;
            layoutParams.gravity = 17;
            window.setAttributes(layoutParams);
            this.setCanceledOnTouchOutside(false);
            this.initViews();
        }

        private void initViews() {
            this.mBackgroundLayout = (BackgroundLayout)this.findViewById(R.id.background);
            this.mBackgroundLayout.setBaseColor(KProgressHUD.this.mWindowColor);
            this.mBackgroundLayout.setCornerRadius(KProgressHUD.this.mCornerRadius);
            if (this.mWidth != 0) {
                this.updateBackgroundSize();
            }
            this.mCustomViewContainer = (FrameLayout)this.findViewById(R.id.container);
            this.addViewToFrame(this.mView);
            if (this.mDeterminateView != null) {
                this.mDeterminateView.setMax(KProgressHUD.this.mMaxProgress);
            }
            if (this.mIndeterminateView != null) {
                this.mIndeterminateView.setAnimationSpeed(KProgressHUD.this.mAnimateSpeed);
            }
            this.mLabelText = (TextView)this.findViewById(R.id.label);
            this.setLabel(this.mLabel, this.mLabelColor);
            this.mDetailsText = (TextView)this.findViewById(R.id.details_label);
            this.setDetailsLabel(this.mDetailsLabel, this.mDetailColor);
        }

        private void addViewToFrame(View view) {
            if (view == null) {
                return;
            }
            int wrapParam = -2;
            ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(wrapParam, wrapParam);
            this.mCustomViewContainer.addView(view, params);
        }

        private void updateBackgroundSize() {
            ViewGroup.LayoutParams params = this.mBackgroundLayout.getLayoutParams();
            params.width = Helper.dpToPixel(this.mWidth, this.getContext());
            params.height = Helper.dpToPixel(this.mHeight, this.getContext());
            this.mBackgroundLayout.setLayoutParams(params);
        }

        public void setProgress(int progress) {
            if (this.mDeterminateView != null) {
                this.mDeterminateView.setProgress(progress);
                if (KProgressHUD.this.mIsAutoDismiss && progress >= KProgressHUD.this.mMaxProgress) {
                    this.dismiss();
                }
            }
        }

        public void setView(View view) {
            if (view != null) {
                if (view instanceof Determinate) {
                    this.mDeterminateView = (Determinate)view;
                }
                if (view instanceof Indeterminate) {
                    this.mIndeterminateView = (Indeterminate)view;
                }
                this.mView = view;
                if (this.isShowing()) {
                    this.mCustomViewContainer.removeAllViews();
                    this.addViewToFrame(view);
                }
            }
        }

        public void setLabel(String label) {
            this.mLabel = label;
            if (this.mLabelText != null) {
                if (label != null) {
                    this.mLabelText.setText((CharSequence)label);
                    this.mLabelText.setVisibility(0);
                } else {
                    this.mLabelText.setVisibility(8);
                }
            }
        }

        public void setDetailsLabel(String detailsLabel) {
            this.mDetailsLabel = detailsLabel;
            if (this.mDetailsText != null) {
                if (detailsLabel != null) {
                    this.mDetailsText.setText((CharSequence)detailsLabel);
                    this.mDetailsText.setVisibility(0);
                } else {
                    this.mDetailsText.setVisibility(8);
                }
            }
        }

        public void setLabel(String label, int color2) {
            this.mLabel = label;
            this.mLabelColor = color2;
            if (this.mLabelText != null) {
                if (label != null) {
                    this.mLabelText.setText((CharSequence)label);
                    this.mLabelText.setTextColor(color2);
                    this.mLabelText.setVisibility(0);
                } else {
                    this.mLabelText.setVisibility(8);
                }
            }
        }

        public void setDetailsLabel(String detailsLabel, int color2) {
            this.mDetailsLabel = detailsLabel;
            this.mDetailColor = color2;
            if (this.mDetailsText != null) {
                if (detailsLabel != null) {
                    this.mDetailsText.setText((CharSequence)detailsLabel);
                    this.mDetailsText.setTextColor(color2);
                    this.mDetailsText.setVisibility(0);
                } else {
                    this.mDetailsText.setVisibility(8);
                }
            }
        }

        public void setSize(int width, int height) {
            this.mWidth = width;
            this.mHeight = height;
            if (this.mBackgroundLayout != null) {
                this.updateBackgroundSize();
            }
        }
    }

    public static enum Style {
        SPIN_INDETERMINATE,
        PIE_DETERMINATE,
        ANNULAR_DETERMINATE,
        BAR_DETERMINATE;

    }
}

