/*
 * Decompiled with CFR 0.152.
 */
package io.github.rupinderjeet.kprogresshud;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import io.github.rupinderjeet.kprogresshud.Determinate;
import io.github.rupinderjeet.kprogresshud.Helper;
import io.github.rupinderjeet.kprogresshud.R;

class AnnularView
extends View
implements Determinate {
    private Paint mWhitePaint;
    private Paint mGreyPaint;
    private RectF mBound;
    private int mMax = 100;
    private int mProgress = 0;

    public AnnularView(Context context) {
        super(context);
        this.init(context);
    }

    public AnnularView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public AnnularView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.mWhitePaint = new Paint(1);
        this.mWhitePaint.setStyle(Paint.Style.STROKE);
        this.mWhitePaint.setStrokeWidth((float)Helper.dpToPixel(3.0f, this.getContext()));
        this.mWhitePaint.setColor(-1);
        this.mGreyPaint = new Paint(1);
        this.mGreyPaint.setStyle(Paint.Style.STROKE);
        this.mGreyPaint.setStrokeWidth((float)Helper.dpToPixel(3.0f, this.getContext()));
        this.mGreyPaint.setColor(context.getResources().getColor(R.color.kprogresshud_grey_color));
        this.mBound = new RectF();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        int padding = Helper.dpToPixel(4.0f, this.getContext());
        this.mBound.set((float)padding, (float)padding, (float)(w - padding), (float)(h - padding));
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        float mAngle = (float)this.mProgress * 360.0f / (float)this.mMax;
        canvas.drawArc(this.mBound, 270.0f, mAngle, false, this.mWhitePaint);
        canvas.drawArc(this.mBound, 270.0f + mAngle, 360.0f - mAngle, false, this.mGreyPaint);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int dimension = Helper.dpToPixel(40.0f, this.getContext());
        this.setMeasuredDimension(dimension, dimension);
    }

    @Override
    public void setMax(int max) {
        this.mMax = max;
    }

    @Override
    public void setProgress(int progress) {
        this.mProgress = progress;
        this.invalidate();
    }
}

