/*
 * Decompiled with CFR 0.152.
 */
package io.github.roguedog.devhelper.cloud.eureka.discovery.registry;

import io.github.roguedog.devhelper.cloud.DevHelperDiscoveryServiceIdUtils;
import io.github.roguedog.devhelper.cloud.registry.DevHelperRegistryProperties;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cloud.netflix.eureka.EurekaInstanceConfigBean;

public class EurekaConfigBeanPostProcessor
implements BeanPostProcessor {
    private DevHelperRegistryProperties registryProperties;

    public EurekaConfigBeanPostProcessor(DevHelperRegistryProperties registryProperties) {
        this.registryProperties = registryProperties;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof EurekaInstanceConfigBean) {
            EurekaInstanceConfigBean configBean = (EurekaInstanceConfigBean)bean;
            String appName = configBean.getAppname();
            String newAppName = DevHelperDiscoveryServiceIdUtils.buildRegistryServiceIdBySuffix((String)appName, (String)this.registryProperties.getSuffix());
            configBean.setAppname(newAppName);
            configBean.setSecureVirtualHostName(newAppName);
            configBean.setVirtualHostName(newAppName);
        }
        return bean;
    }
}

