/*
 * Decompiled with CFR 0.152.
 */
package io.github.robwin.swagger2markup.utils;

import com.google.common.base.Optional;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import io.swagger.models.HttpMethod;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagUtils {
    private static Logger LOG = LoggerFactory.getLogger(TagUtils.class);

    public static Map<String, Tag> convertTagsListToMap(List<Tag> tags) {
        if (tags == null) {
            tags = new ArrayList<Tag>();
        }
        HashMap<String, Tag> tagsMap = new HashMap<String, Tag>();
        for (Tag tag : tags) {
            tagsMap.put(tag.getName(), tag);
        }
        return tagsMap;
    }

    public static Optional<String> getTagDescription(Map<String, Tag> tagsMap, String tagName) {
        Tag tag = tagsMap.get(tagName);
        if (tag != null) {
            return Optional.fromNullable((Object)tag.getDescription());
        }
        return Optional.absent();
    }

    public static Multimap<String, Pair<String, Path>> groupPathsByTag(Map<String, Path> paths) {
        SetMultimap pathsGroupedByTag = MultimapBuilder.SortedSetMultimapBuilder.treeKeys().hashSetValues().build();
        for (Map.Entry<String, Path> pathEntry : paths.entrySet()) {
            String resourcePath = pathEntry.getKey();
            Path path = pathEntry.getValue();
            for (Map.Entry operationEntry : path.getOperationMap().entrySet()) {
                HttpMethod httpMethod = (HttpMethod)operationEntry.getKey();
                Operation operation = (Operation)operationEntry.getValue();
                if (operation == null) continue;
                List tags = operation.getTags();
                Validate.notEmpty((Collection)tags, (String)"Path operations must have tags, if you want to group by tags! The operation '%s %s' has not tags.", (Object[])new Object[]{httpMethod, resourcePath});
                for (String tag : tags) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info("Added path operation '{} {}' to tag '{}'", new Object[]{httpMethod, resourcePath, tag});
                    }
                    pathsGroupedByTag.put((Object)tag, (Object)Pair.of((Object)resourcePath, (Object)pathEntry.getValue()));
                }
            }
        }
        return pathsGroupedByTag;
    }
}

