/*
 * Decompiled with CFR 0.152.
 */
package io.github.robwin.swagger2markup.utils;

import io.github.robwin.markup.builder.MarkupLanguage;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import io.swagger.models.properties.UUIDProperty;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public final class PropertyUtils {
    public static String getType(Property property, MarkupLanguage markupLanguage) {
        String type;
        Validate.notNull((Object)property, (String)"property must not be null!", (Object[])new Object[0]);
        if (property instanceof RefProperty) {
            RefProperty refProperty = (RefProperty)property;
            switch (markupLanguage) {
                case ASCIIDOC: {
                    return "<<" + refProperty.getSimpleRef() + ">>";
                }
            }
            return refProperty.getSimpleRef();
        }
        if (property instanceof ArrayProperty) {
            ArrayProperty arrayProperty = (ArrayProperty)property;
            Property items = arrayProperty.getItems();
            type = PropertyUtils.getType(items, markupLanguage) + " " + arrayProperty.getType();
        } else {
            StringProperty stringProperty;
            List enums;
            type = property instanceof StringProperty ? (CollectionUtils.isNotEmpty((Collection)(enums = (stringProperty = (StringProperty)property).getEnum())) ? "enum (" + StringUtils.join((Iterable)enums, (String)", ") + ")" : property.getType()) : (StringUtils.isNotBlank((CharSequence)property.getFormat()) ? StringUtils.defaultString((String)property.getType()) + " (" + property.getFormat() + ")" : property.getType());
        }
        return StringUtils.defaultString((String)type);
    }

    public static String getDefaultValue(Property property) {
        Validate.notNull((Object)property, (String)"property must not be null!", (Object[])new Object[0]);
        String defaultValue = "";
        if (property instanceof BooleanProperty) {
            BooleanProperty booleanProperty = (BooleanProperty)property;
            defaultValue = Objects.toString(booleanProperty.getDefault(), "");
        } else if (property instanceof StringProperty) {
            StringProperty stringProperty = (StringProperty)property;
            defaultValue = Objects.toString(stringProperty.getDefault(), "");
        } else if (property instanceof DoubleProperty) {
            DoubleProperty doubleProperty = (DoubleProperty)property;
            defaultValue = Objects.toString(doubleProperty.getDefault(), "");
        } else if (property instanceof FloatProperty) {
            FloatProperty floatProperty = (FloatProperty)property;
            defaultValue = Objects.toString(floatProperty.getDefault(), "");
        } else if (property instanceof IntegerProperty) {
            IntegerProperty integerProperty = (IntegerProperty)property;
            defaultValue = Objects.toString(integerProperty.getDefault(), "");
        } else if (property instanceof LongProperty) {
            LongProperty longProperty = (LongProperty)property;
            defaultValue = Objects.toString(longProperty.getDefault(), "");
        } else if (property instanceof UUIDProperty) {
            UUIDProperty uuidProperty = (UUIDProperty)property;
            defaultValue = Objects.toString(uuidProperty.getDefault(), "");
        }
        return defaultValue;
    }
}

