/*
 * Decompiled with CFR 0.152.
 */
package com.harissk.pdfpreview.source;

import android.content.Context;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import com.harissk.pdfium.PdfiumCore;
import com.harissk.pdfpreview.source.DocumentSource;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/harissk/pdfpreview/source/UriSource;", "Lcom/harissk/pdfpreview/source/DocumentSource;", "uri", "Landroid/net/Uri;", "(Landroid/net/Uri;)V", "createDocument", "", "context", "Landroid/content/Context;", "core", "Lcom/harissk/pdfium/PdfiumCore;", "password", "", "pdfpreview_release"})
public final class UriSource
implements DocumentSource {
    @NotNull
    private final Uri uri;

    public UriSource(@NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        this.uri = uri;
    }

    @Override
    public long createDocument(@NotNull Context context, @NotNull PdfiumCore core, @Nullable String password) throws IOException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)core, (String)"core");
        ParcelFileDescriptor parcelFileDescriptor = context.getContentResolver().openFileDescriptor(this.uri, "r");
        if (parcelFileDescriptor == null) {
            throw new IOException("Unable to open document");
        }
        return core.newDocument(parcelFileDescriptor, password);
    }
}

