/*
 * Decompiled with CFR 0.152.
 */
package com.harissk.pdfpreview;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.PointF;
import android.view.animation.DecelerateInterpolator;
import android.widget.OverScroller;
import com.harissk.pdfpreview.PDFView;
import com.harissk.pdfpreview.scroll.ScrollHandle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0019\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\nH\u0002JF\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u0016J\u0016\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u0011J\u0016\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u00112\u0006\u0010#\u001a\u00020\u0011J\u0006\u0010$\u001a\u00020\u000fJ\u0006\u0010%\u001a\u00020\u000fJ\u000e\u0010&\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u0011J\b\u0010(\u001a\u00020\u000fH\u0002J\u0006\u0010)\u001a\u00020\u000fJ&\u0010*\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020\u00112\u0006\u0010,\u001a\u00020\u00112\u0006\u0010-\u001a\u00020\u00112\u0006\u0010.\u001a\u00020\u0011R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/harissk/pdfpreview/PdfAnimator;", "", "pdfView", "Lcom/harissk/pdfpreview/PDFView;", "(Lcom/harissk/pdfpreview/PDFView;)V", "activeAnimation", "Landroid/animation/ValueAnimator;", "flingScroller", "Landroid/widget/OverScroller;", "flinging", "", "isFlinging", "()Z", "isPageAnimating", "animate", "", "startValue", "", "targetValue", "isAnimatingVertically", "animateFling", "flingStartX", "", "flingStartY", "flingVelocityX", "flingVelocityY", "flingMinX", "flingMaxX", "flingMinY", "flingMaxY", "animateHorizontal", "startX", "targetX", "animateVertical", "startY", "targetY", "cancelAllAnimations", "cancelFling", "flingToPage", "pageTargetOffset", "handleAnimationEnd", "performFling", "zoomToPoint", "zoomCenterX", "zoomCenterY", "startZoom", "targetZoom", "pdfpreview_release"})
public final class PdfAnimator {
    @NotNull
    private final PDFView pdfView;
    @Nullable
    private ValueAnimator activeAnimation;
    @NotNull
    private final OverScroller flingScroller;
    private boolean flinging;
    private boolean isPageAnimating;

    public PdfAnimator(@NotNull PDFView pdfView) {
        Intrinsics.checkNotNullParameter((Object)((Object)pdfView), (String)"pdfView");
        this.pdfView = pdfView;
        this.flingScroller = new OverScroller(this.pdfView.getContext());
    }

    public final void animateHorizontal(float startX, float targetX) {
        this.animate(startX, targetX, false);
    }

    public final void animateVertical(float startY, float targetY) {
        this.animate(startY, targetY, true);
    }

    /*
     * WARNING - void declaration
     */
    private final void animate(float startValue, float targetValue, boolean isAnimatingVertically) {
        void $this$animate_u24lambda_u241;
        if (this.pdfView.isRecycled$pdfpreview_release()) {
            return;
        }
        ValueAnimator valueAnimator = this.activeAnimation;
        if (valueAnimator != null) {
            valueAnimator.cancel();
        }
        Object object = new float[]{startValue, targetValue};
        Object object2 = object = (Object)ValueAnimator.ofFloat((float[])object);
        PdfAnimator pdfAnimator = this;
        boolean bl = false;
        $this$animate_u24lambda_u241.setDuration(400L);
        $this$animate_u24lambda_u241.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        $this$animate_u24lambda_u241.addUpdateListener(arg_0 -> PdfAnimator.animate$lambda$1$lambda$0(this, isAnimatingVertically, arg_0));
        $this$animate_u24lambda_u241.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(this){
            final /* synthetic */ PdfAnimator this$0;
            {
                this.this$0 = $receiver;
            }

            public void onAnimationEnd(@NotNull Animator animation) {
                Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                PdfAnimator.access$handleAnimationEnd(this.this$0);
            }

            public void onAnimationCancel(@NotNull Animator animation) {
                Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                PdfAnimator.access$handleAnimationEnd(this.this$0);
            }
        });
        $this$animate_u24lambda_u241.start();
        pdfAnimator.activeAnimation = (ValueAnimator)object;
    }

    private final void handleAnimationEnd() {
        block1: {
            if (this.pdfView.isRecycled$pdfpreview_release()) {
                return;
            }
            this.pdfView.updateScrollUIElements$pdfpreview_release();
            this.pdfView.loadPages$pdfpreview_release();
            this.isPageAnimating = false;
            ScrollHandle scrollHandle = this.pdfView.getScrollHandle$pdfpreview_release();
            if (scrollHandle == null) break block1;
            scrollHandle.hideDelayed();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void zoomToPoint(float zoomCenterX, float zoomCenterY, float startZoom, float targetZoom) {
        void $this$zoomToPoint_u24lambda_u243;
        if (this.pdfView.isRecycled$pdfpreview_release()) {
            return;
        }
        this.cancelAllAnimations();
        Object object = new float[]{startZoom, targetZoom};
        Object object2 = object = (Object)ValueAnimator.ofFloat((float[])object);
        PdfAnimator pdfAnimator = this;
        boolean bl = false;
        $this$zoomToPoint_u24lambda_u243.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        $this$zoomToPoint_u24lambda_u243.addUpdateListener(arg_0 -> PdfAnimator.zoomToPoint$lambda$3$lambda$2(this, zoomCenterX, zoomCenterY, arg_0));
        $this$zoomToPoint_u24lambda_u243.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(this, targetZoom, startZoom){
            final /* synthetic */ PdfAnimator this$0;
            final /* synthetic */ float $targetZoom;
            final /* synthetic */ float $startZoom;
            {
                this.this$0 = $receiver;
                this.$targetZoom = $targetZoom;
                this.$startZoom = $startZoom;
            }

            public void onAnimationEnd(@NotNull Animator animation) {
                Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                PdfAnimator.access$getPdfView$p(this.this$0).loadPages$pdfpreview_release();
                PdfAnimator.access$getPdfView$p(this.this$0).performPageSnap$pdfpreview_release();
                ScrollHandle scrollHandle = PdfAnimator.access$getPdfView$p(this.this$0).getScrollHandle$pdfpreview_release();
                if (scrollHandle != null) {
                    scrollHandle.hideDelayed();
                }
                PdfAnimator.access$getPdfView$p(this.this$0).notifyZoomChanged$pdfpreview_release(this.$targetZoom, this.$startZoom);
            }

            public void onAnimationCancel(@NotNull Animator animation) {
                Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                PdfAnimator.access$getPdfView$p(this.this$0).loadPages$pdfpreview_release();
                ScrollHandle scrollHandle = PdfAnimator.access$getPdfView$p(this.this$0).getScrollHandle$pdfpreview_release();
                if (scrollHandle != null) {
                    scrollHandle.hideDelayed();
                }
                PdfAnimator.access$getPdfView$p(this.this$0).notifyZoomChanged$pdfpreview_release(PdfAnimator.access$getPdfView$p(this.this$0).getZoom(), this.$startZoom);
            }
        });
        $this$zoomToPoint_u24lambda_u243.setDuration(400L);
        $this$zoomToPoint_u24lambda_u243.start();
        pdfAnimator.activeAnimation = (ValueAnimator)object;
    }

    public final void animateFling(int flingStartX, int flingStartY, int flingVelocityX, int flingVelocityY, int flingMinX, int flingMaxX, int flingMinY, int flingMaxY) {
        if (this.pdfView.isRecycled$pdfpreview_release()) {
            this.flinging = false;
            return;
        }
        this.cancelAllAnimations();
        this.flinging = true;
        this.flingScroller.fling(flingStartX, flingStartY, flingVelocityX, flingVelocityY, flingMinX, flingMaxX, flingMinY, flingMaxY);
    }

    public final void flingToPage(float pageTargetOffset) {
        if (this.pdfView.isRecycled$pdfpreview_release()) {
            return;
        }
        if (this.pdfView.isSwipeVertical$pdfpreview_release()) {
            this.animateVertical(this.pdfView.getCurrentYOffset(), pageTargetOffset);
        } else {
            this.animateHorizontal(this.pdfView.getCurrentXOffset(), pageTargetOffset);
        }
        this.isPageAnimating = true;
    }

    public final void performFling() {
        if (this.pdfView.isRecycled$pdfpreview_release() || !this.flinging) {
            return;
        }
        if (this.flingScroller.computeScrollOffset()) {
            this.pdfView.moveTo$pdfpreview_release(this.flingScroller.getCurrX(), this.flingScroller.getCurrY(), true);
            this.pdfView.invalidate();
        } else {
            this.flinging = false;
            if (!this.pdfView.isRecycled$pdfpreview_release()) {
                this.pdfView.updateScrollUIElements$pdfpreview_release();
                this.pdfView.loadPages$pdfpreview_release();
                ScrollHandle scrollHandle = this.pdfView.getScrollHandle$pdfpreview_release();
                if (scrollHandle != null) {
                    scrollHandle.hideDelayed();
                }
                this.pdfView.performPageSnap$pdfpreview_release();
            }
        }
    }

    public final void cancelAllAnimations() {
        ValueAnimator valueAnimator = this.activeAnimation;
        if (valueAnimator != null) {
            valueAnimator.cancel();
        }
        this.activeAnimation = null;
        this.cancelFling();
    }

    public final void cancelFling() {
        this.flinging = false;
        this.flingScroller.forceFinished(true);
    }

    public final boolean isFlinging() {
        return this.flinging || this.isPageAnimating;
    }

    private static final void animate$lambda$1$lambda$0(PdfAnimator this$0, boolean $isAnimatingVertically, ValueAnimator valueAnimator) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)valueAnimator, (String)"valueAnimator");
        Object object = valueAnimator.getAnimatedValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Float");
        float animationValue = ((Float)object).floatValue();
        this$0.pdfView.moveTo$pdfpreview_release($isAnimatingVertically ? this$0.pdfView.getCurrentXOffset() : animationValue, $isAnimatingVertically ? animationValue : this$0.pdfView.getCurrentYOffset(), true);
    }

    private static final void zoomToPoint$lambda$3$lambda$2(PdfAnimator this$0, float $zoomCenterX, float $zoomCenterY, ValueAnimator valueAnimator) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)valueAnimator, (String)"valueAnimator");
        PDFView pDFView = this$0.pdfView;
        Object object = valueAnimator.getAnimatedValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Float");
        pDFView.zoomCenteredTo(((Float)object).floatValue(), new PointF($zoomCenterX, $zoomCenterY));
    }

    public static final /* synthetic */ void access$handleAnimationEnd(PdfAnimator $this) {
        $this.handleAnimationEnd();
    }

    public static final /* synthetic */ PDFView access$getPdfView$p(PdfAnimator $this) {
        return $this.pdfView;
    }
}

