/*
 * Decompiled with CFR 0.152.
 */
package com.harissk.pdfium;

import android.graphics.Bitmap;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.RectF;
import android.os.ParcelFileDescriptor;
import android.util.ArrayMap;
import android.view.Surface;
import com.harissk.pdfium.Bookmark;
import com.harissk.pdfium.Link;
import com.harissk.pdfium.Meta;
import com.harissk.pdfium.PdfiumCore;
import com.harissk.pdfium.exception.PageRenderingException;
import com.harissk.pdfium.listener.LogWriter;
import com.harissk.pdfium.search.FPDFTextSearchContext;
import com.harissk.pdfium.search.TextSearchContext;
import com.harissk.pdfium.util.FileUtils;
import com.harissk.pdfium.util.Size;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00e0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0015\n\u0002\b\u0006\n\u0002\u0010\u0016\n\u0002\b-\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0017\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 \u00d1\u00012\u00020\u0001:\u0002\u00d1\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0002J\u000e\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0004J\u000e\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004J\u001e\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004J\u0010\u0010\u001d\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0004H\u0002J\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u0004J \u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u0004J\u0018\u0010%\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010&\u001a\u00020'J.\u0010(\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020*2\u0006\u0010-\u001a\u00020*J\u000e\u0010.\u001a\u00020/H\u0086@\u00a2\u0006\u0002\u00100J\u000e\u00101\u001a\u00020\"2\u0006\u00102\u001a\u00020\u0004J\u000e\u00103\u001a\u00020\u00042\u0006\u00104\u001a\u00020\rJ\u000e\u00105\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u0004J\u000e\u00106\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u0004J\u0014\u00107\u001a\b\u0012\u0004\u0012\u000209082\u0006\u0010\u0018\u001a\u00020\u0004J\u000e\u0010:\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u0004J\u000e\u0010;\u001a\u00020<2\u0006\u0010 \u001a\u00020\u0004J\u000e\u0010=\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u0004J\u000e\u0010>\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u0004J\u0014\u0010?\u001a\b\u0012\u0004\u0012\u00020@08H\u0086@\u00a2\u0006\u0002\u00100J\u0018\u0010A\u001a\u0004\u0018\u00010'2\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010B\u001a\u00020\u0004J\u000e\u0010C\u001a\u00020D2\u0006\u0010 \u001a\u00020\u0004J\u000e\u0010E\u001a\u00020D2\u0006\u0010 \u001a\u00020\u0004J\u000e\u0010F\u001a\u00020D2\u0006\u0010 \u001a\u00020\u0004J\u0017\u0010G\u001a\u00020D2\b\u0010H\u001a\u0004\u0018\u00010\rH\u0002\u00a2\u0006\u0002\u0010IJF\u0010J\u001a\u00020K2\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010L\u001a\u00020\u00042\u0006\u0010M\u001a\u00020\u00042\u0006\u0010N\u001a\u00020\u00042\u0006\u0010O\u001a\u00020\u00042\u0006\u0010P\u001a\u00020\u00042\u0006\u0010Q\u001a\u00020\u00042\u0006\u0010R\u001a\u00020\u0004J>\u0010S\u001a\u00020'2\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010L\u001a\u00020\u00042\u0006\u0010M\u001a\u00020\u00042\u0006\u0010N\u001a\u00020\u00042\u0006\u0010O\u001a\u00020\u00042\u0006\u0010P\u001a\u00020\u00042\u0006\u0010T\u001a\u00020'JH\u0010U\u001a\u00020V2\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010L\u001a\u00020\u00042\u0006\u0010M\u001a\u00020\u00042\u0006\u0010N\u001a\u00020\u00042\u0006\u0010O\u001a\u00020\u00042\u0006\u0010P\u001a\u00020\u00042\u0006\u0010W\u001a\u00020*2\u0006\u0010X\u001a\u00020*H\u0002J\u0018\u0010Y\u001a\u0004\u0018\u00010'2\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u0004J1\u0010Z\u001a\u00020\r2\u0006\u00104\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010[\u001a\u00020\"2\u0006\u0010\\\u001a\u00020]2\u0006\u0010^\u001a\u00020]H\u0082 J\u0011\u0010_\u001a\u00020\u00152\u0006\u00104\u001a\u00020\rH\u0082 J\u0011\u0010`\u001a\u00020\u00152\u0006\u0010a\u001a\u00020\rH\u0082 J\u0011\u0010b\u001a\u00020\u00152\u0006\u0010c\u001a\u00020dH\u0082 J\u0011\u0010e\u001a\u00020\u00152\u0006\u0010a\u001a\u00020\rH\u0082 J\u0011\u0010f\u001a\u00020\u00152\u0006\u0010c\u001a\u00020dH\u0082 J\u0011\u0010g\u001a\u00020\u00042\u0006\u0010h\u001a\u00020\rH\u0082 JI\u0010i\u001a\u00020K2\u0006\u0010a\u001a\u00020\r2\u0006\u0010L\u001a\u00020\u00042\u0006\u0010M\u001a\u00020\u00042\u0006\u0010N\u001a\u00020\u00042\u0006\u0010O\u001a\u00020\u00042\u0006\u0010P\u001a\u00020\u00042\u0006\u0010Q\u001a\u00020\u00042\u0006\u0010R\u001a\u00020\u0004H\u0082 J\u001e\u0010j\u001a\u00020\r2\u0006\u00104\u001a\u00020\r2\u0006\u0010k\u001a\u00020\rH\u0082`\u00a2\u0006\u0002\u0010lJ\u0018\u0010m\u001a\u0004\u0018\u00010\"2\u0006\u0010k\u001a\u00020\rH\u0082`\u00a2\u0006\u0002\u0010nJ\u0011\u0010o\u001a\u00020\u00042\u0006\u0010h\u001a\u00020\rH\u0082 J \u0010p\u001a\u0004\u0018\u00010\u00042\u0006\u00104\u001a\u00020\r2\u0006\u0010q\u001a\u00020\rH\u0082 \u00a2\u0006\u0002\u0010rJ \u0010s\u001a\u0004\u0018\u00010\"2\u0006\u00104\u001a\u00020\r2\u0006\u0010t\u001a\u00020\"H\u0082`\u00a2\u0006\u0002\u0010uJ\u0011\u0010v\u001a\u00020\"2\u0006\u00102\u001a\u00020\u0004H\u0082 J\"\u0010w\u001a\u0004\u0018\u00010\r2\u0006\u00104\u001a\u00020\r2\b\u0010k\u001a\u0004\u0018\u00010\rH\u0082`\u00a2\u0006\u0002\u0010xJ\u0011\u0010y\u001a\u00020\u00042\u0006\u00104\u001a\u00020\rH\u0082 J\u0013\u0010z\u001a\u0004\u0018\u00010'2\u0006\u0010q\u001a\u00020\rH\u0082 J\u001b\u0010{\u001a\u0004\u0018\u00010\"2\u0006\u00104\u001a\u00020\r2\u0006\u0010q\u001a\u00020\rH\u0082 J\u0011\u0010|\u001a\u00020\u00042\u0006\u00104\u001a\u00020\rH\u0082 J\u0019\u0010}\u001a\u00020\u00042\u0006\u0010a\u001a\u00020\r2\u0006\u0010~\u001a\u00020\u0004H\u0082 J\u0011\u0010\u007f\u001a\u00020\u00042\u0006\u0010a\u001a\u00020\rH\u0082 J\u0012\u0010\u0080\u0001\u001a\u00020d2\u0006\u0010a\u001a\u00020\rH\u0082 J\u0012\u0010\u0081\u0001\u001a\u00020\u00042\u0006\u0010a\u001a\u00020\rH\u0082 J\"\u0010\u0082\u0001\u001a\u00020<2\u0006\u00104\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010~\u001a\u00020\u0004H\u0082 J\u001a\u0010\u0083\u0001\u001a\u00020\u00042\u0006\u0010a\u001a\u00020\r2\u0006\u0010~\u001a\u00020\u0004H\u0082 J\u0012\u0010\u0084\u0001\u001a\u00020\u00042\u0006\u0010a\u001a\u00020\rH\u0082 J!\u0010\u0085\u0001\u001a\u0004\u0018\u00010\r2\u0006\u00104\u001a\u00020\r2\u0006\u0010k\u001a\u00020\rH\u0082`\u00a2\u0006\u0002\u0010lJ\u001a\u0010\u0086\u0001\u001a\u00020\r2\u0006\u00104\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0004H\u0082 J$\u0010\u0087\u0001\u001a\u00020d2\u0006\u00104\u001a\u00020\r2\u0007\u0010\u0088\u0001\u001a\u00020\u00042\u0007\u0010\u0089\u0001\u001a\u00020\u0004H\u0082 J\u001a\u0010\u008a\u0001\u001a\u00020\r2\u0006\u00104\u001a\u00020\r2\u0006\u0010a\u001a\u00020\rH\u0082 J\u001b\u0010\u008b\u0001\u001a\u00020d2\u0006\u00104\u001a\u00020\r2\u0007\u0010\u008c\u0001\u001a\u00020dH\u0082 J\u001e\u0010\u008d\u0001\u001a\u00020\r2\u0007\u0010\u008e\u0001\u001a\u00020\u00042\t\u0010\u008f\u0001\u001a\u0004\u0018\u00010\"H\u0082 J\u001f\u0010\u0090\u0001\u001a\u00020\r2\b\u0010\u0091\u0001\u001a\u00030\u0092\u00012\t\u0010\u008f\u0001\u001a\u0004\u0018\u00010\"H\u0082 JJ\u0010\u0093\u0001\u001a\u00020V2\u0006\u0010a\u001a\u00020\r2\u0006\u0010L\u001a\u00020\u00042\u0006\u0010M\u001a\u00020\u00042\u0006\u0010N\u001a\u00020\u00042\u0006\u0010O\u001a\u00020\u00042\u0006\u0010P\u001a\u00020\u00042\u0006\u0010W\u001a\u00020*2\u0006\u0010X\u001a\u00020*H\u0082 JG\u0010\u0094\u0001\u001a\u00020\u00152\u0006\u0010a\u001a\u00020\r2\b\u0010\u0095\u0001\u001a\u00030\u0096\u00012\u0006\u0010L\u001a\u00020\u00042\u0006\u0010M\u001a\u00020\u00042\u0007\u0010\u0097\u0001\u001a\u00020\u00042\u0007\u0010\u0098\u0001\u001a\u00020\u00042\u0007\u0010\u0099\u0001\u001a\u00020DH\u0082 JG\u0010\u009a\u0001\u001a\u00020\u00152\u0006\u0010a\u001a\u00020\r2\b\u0010\u009b\u0001\u001a\u00030\u009c\u00012\u0006\u0010L\u001a\u00020\u00042\u0006\u0010M\u001a\u00020\u00042\u0007\u0010\u0097\u0001\u001a\u00020\u00042\u0007\u0010\u0098\u0001\u001a\u00020\u00042\u0007\u0010\u0099\u0001\u001a\u00020DH\u0082 J\u0012\u0010\u009d\u0001\u001a\u00020D2\u0006\u0010h\u001a\u00020\rH\u0082 J\u0012\u0010\u009e\u0001\u001a\u00020D2\u0006\u0010h\u001a\u00020\rH\u0082 J.\u0010\u009f\u0001\u001a\u00020\r2\u0007\u0010\u00a0\u0001\u001a\u00020\r2\u0007\u0010\u00a1\u0001\u001a\u00020\"2\u0007\u0010\u00a2\u0001\u001a\u00020D2\u0007\u0010\u00a3\u0001\u001a\u00020DH\u0082 J\u0012\u0010\u00a4\u0001\u001a\u00020\u00152\u0006\u0010h\u001a\u00020\rH\u0082 J\u0013\u0010\u00a5\u0001\u001a\u00020\u00042\u0007\u0010\u00a0\u0001\u001a\u00020\rH\u0082 J$\u0010\u00a6\u0001\u001a\u00020\u00042\u0007\u0010\u00a0\u0001\u001a\u00020\r2\u0007\u0010\u00a7\u0001\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004H\u0082 JA\u0010\u00a8\u0001\u001a\u00020\u00042\u0007\u0010\u00a0\u0001\u001a\u00020\r2\u0007\u0010\u00a9\u0001\u001a\u00020*2\u0007\u0010\u00aa\u0001\u001a\u00020*2\u0007\u0010\u00ab\u0001\u001a\u00020*2\u0007\u0010\u00ac\u0001\u001a\u00020*2\b\u0010\u00ad\u0001\u001a\u00030\u00ae\u0001H\u0082 J7\u0010\u00af\u0001\u001a\u00020\u00042\u0007\u0010\u00a0\u0001\u001a\u00020\r2\u0007\u0010\u00a9\u0001\u001a\u00020*2\u0007\u0010\u00aa\u0001\u001a\u00020*2\u0007\u0010\u00ab\u0001\u001a\u00020*2\u0007\u0010\u00ac\u0001\u001a\u00020*H\u0082 J\u001c\u0010\u00b0\u0001\u001a\u00030\u00b1\u00012\u0007\u0010\u00a0\u0001\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u0004H\u0082 J3\u0010\u00b2\u0001\u001a\u00020\u00042\u0007\u0010\u00a0\u0001\u001a\u00020\r2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020*2\u0006\u0010-\u001a\u00020*H\u0082 J\u001d\u0010\u00b3\u0001\u001a\u00030\u00b1\u00012\u0007\u0010\u00a0\u0001\u001a\u00020\r2\u0007\u0010\u00b4\u0001\u001a\u00020\u0004H\u0082 J.\u0010\u00b5\u0001\u001a\u00020\u00042\u0007\u0010\u00a0\u0001\u001a\u00020\r2\u0007\u0010\u00a7\u0001\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\b\u0010\u00b6\u0001\u001a\u00030\u00ae\u0001H\u0082 J\u001b\u0010\u00b7\u0001\u001a\u00020\u00042\u0007\u0010\u00a0\u0001\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u0004H\u0082 J\u0010\u0010\u00b8\u0001\u001a\u00020\u00152\u0007\u0010\u008e\u0001\u001a\u00020\u000bJ\u001b\u0010\u00b8\u0001\u001a\u00020\r2\u0007\u0010\u008e\u0001\u001a\u00020\u000b2\t\u0010\u008f\u0001\u001a\u0004\u0018\u00010\"J\u001c\u0010\u00b8\u0001\u001a\u00020\r2\b\u0010\u00b9\u0001\u001a\u00030\u0092\u00012\t\u0010\u008f\u0001\u001a\u0004\u0018\u00010\"J+\u0010\u00ba\u0001\u001a\u00030\u00bb\u00012\u0006\u0010\u0018\u001a\u00020\u00042\u0007\u0010\u00a1\u0001\u001a\u00020\"2\u0007\u0010\u00a2\u0001\u001a\u00020D2\u0007\u0010\u00a3\u0001\u001a\u00020DJ\u001a\u0010\u00bc\u0001\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00042\u0007\u0010\u00bd\u0001\u001a\u00020\rH\u0002J\u001a\u0010\u00be\u0001\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00042\u0007\u0010\u00bd\u0001\u001a\u00020\rH\u0002J\u001a\u0010\u00bf\u0001\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00042\u0007\u0010\u00bd\u0001\u001a\u00020\rH\u0002J\u000f\u0010\u00c0\u0001\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0004J\u0019\u0010\u00c0\u0001\u001a\u00020d2\u0007\u0010\u0088\u0001\u001a\u00020\u00042\u0007\u0010\u0089\u0001\u001a\u00020\u0004J\u000f\u0010\u00c1\u0001\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0004J\u0019\u0010\u00c1\u0001\u001a\u00020d2\u0007\u0010\u0088\u0001\u001a\u00020\u00042\u0007\u0010\u0089\u0001\u001a\u00020\u0004J3\u0010\u00c2\u0001\u001a\u00020\u00152\u0019\u0010\u00c3\u0001\u001a\u0014\u0012\u0004\u0012\u00020@0\u00c4\u0001j\t\u0012\u0004\u0012\u00020@`\u00c5\u00012\u0006\u0010k\u001a\u00020\rH\u0082@\u00a2\u0006\u0003\u0010\u00c6\u0001J\u000f\u0010\u00c7\u0001\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0004J\u0019\u0010\u00c7\u0001\u001a\u00020\u00152\u0007\u0010\u0088\u0001\u001a\u00020\u00042\u0007\u0010\u0089\u0001\u001a\u00020\u0004JF\u0010\u00c8\u0001\u001a\u00020\u00152\b\u0010\u0095\u0001\u001a\u00030\u0096\u00012\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010L\u001a\u00020\u00042\u0006\u0010M\u001a\u00020\u00042\u0007\u0010\u00c9\u0001\u001a\u00020\u00042\u0007\u0010\u00ca\u0001\u001a\u00020\u00042\t\b\u0002\u0010\u0099\u0001\u001a\u00020DJF\u0010\u00cb\u0001\u001a\u00020\u00152\b\u0010\u009b\u0001\u001a\u00030\u009c\u00012\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010L\u001a\u00020\u00042\u0006\u0010M\u001a\u00020\u00042\u0007\u0010\u00c9\u0001\u001a\u00020\u00042\u0007\u0010\u00ca\u0001\u001a\u00020\u00042\t\b\u0002\u0010\u0099\u0001\u001a\u00020DJ\u0010\u0010\u00cc\u0001\u001a\u00020\u00152\u0007\u0010\u00cd\u0001\u001a\u00020\u0004J\u000f\u0010\u00ce\u0001\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\bJ\u0012\u0010\u00cf\u0001\u001a\u00020D2\u0007\u0010\u00d0\u0001\u001a\u00020\rH\u0002J\u0019\u0010\u00cf\u0001\u001a\u00020D2\t\u0010\u00d0\u0001\u001a\u0004\u0018\u00010\rH\u0002\u00a2\u0006\u0002\u0010IR\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0006\u00a8\u0006\u00d2\u0001"}, d2={"Lcom/harissk/pdfium/PdfiumCore;", "Ljava/io/Closeable;", "()V", "currentDpi", "", "getCurrentDpi", "()I", "logWriter", "Lcom/harissk/pdfium/listener/LogWriter;", "mCurrentDpi", "mFileDescriptor", "Landroid/os/ParcelFileDescriptor;", "mNativeDocPtr", "", "mNativePagesPtr", "", "mNativeSearchHandlePtr", "mNativeTextPagesPtr", "pageCount", "getPageCount", "close", "", "closeDocument", "closePage", "pageIndex", "countCharactersOnPage", "countTextRect", "charIndex", "count", "ensureTextPage", "extractCharacter", "", "index", "extractCharacters", "", "startIndex", "length", "extractText", "rect", "Landroid/graphics/RectF;", "getCharacterIndex", "x", "", "y", "xTolerance", "yTolerance", "getDocumentMeta", "Lcom/harissk/pdfium/Meta;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getErrorMessage", "errorCode", "getLastError", "docPtr", "getPageHeight", "getPageHeightPoint", "getPageLinks", "", "Lcom/harissk/pdfium/Link;", "getPageRotation", "getPageSize", "Lcom/harissk/pdfium/util/Size;", "getPageWidth", "getPageWidthPoint", "getTableOfContents", "Lcom/harissk/pdfium/Bookmark;", "getTextRect", "rectIndex", "hasPage", "", "hasSearchHandle", "hasTextPage", "isValidPointer", "pointer", "(Ljava/lang/Long;)Z", "mapDeviceCoordinateToPage", "Landroid/graphics/PointF;", "startX", "startY", "sizeX", "sizeY", "rotate", "deviceX", "deviceY", "mapPageCoordinateToDevice", "coords", "mapPageCoordinatesToDevice", "Landroid/graphics/Point;", "pageX", "pageY", "measureCharacterBox", "nativeAddTextAnnotation", "text", "color", "", "bound", "nativeCloseDocument", "nativeClosePage", "pagePtr", "nativeClosePages", "pagesPtr", "", "nativeCloseTextPage", "nativeCloseTextPages", "nativeCountSearchResult", "searchHandlePtr", "nativeDeviceCoordinateToPage", "nativeGetBookmarkDestIndex", "bookmarkPtr", "(JJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "nativeGetBookmarkTitle", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "nativeGetCharIndexOfSearchResult", "nativeGetDestPageIndex", "linkPtr", "(JJ)Ljava/lang/Integer;", "nativeGetDocumentMetaText", "tag", "(JLjava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "nativeGetErrorMessage", "nativeGetFirstChildBookmark", "(JLjava/lang/Long;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "nativeGetLastError", "nativeGetLinkRect", "nativeGetLinkURI", "nativeGetPageCount", "nativeGetPageHeightPixel", "dpi", "nativeGetPageHeightPoint", "nativeGetPageLinks", "nativeGetPageRotation", "nativeGetPageSizeByIndex", "nativeGetPageWidthPixel", "nativeGetPageWidthPoint", "nativeGetSiblingBookmark", "nativeLoadPage", "nativeLoadPages", "fromIndex", "toIndex", "nativeLoadTextPage", "nativeLoadTextPages", "pagePtrs", "nativeOpenDocument", "fd", "password", "nativeOpenMemDocument", "data", "", "nativePageCoordinateToDevice", "nativeRenderPage", "surface", "Landroid/view/Surface;", "drawSizeHor", "drawSizeVer", "renderAnnot", "nativeRenderPageBitmap", "bitmap", "Landroid/graphics/Bitmap;", "nativeSearchNext", "nativeSearchPrev", "nativeSearchStart", "textPagePtr", "query", "matchCase", "matchWholeWord", "nativeSearchStop", "nativeTextCountChars", "nativeTextCountRects", "start_index", "nativeTextGetBoundedText", "left", "top", "right", "bottom", "arr", "", "nativeTextGetBoundedTextLength", "nativeTextGetCharBox", "", "nativeTextGetCharIndexAtPos", "nativeTextGetRect", "rect_index", "nativeTextGetText", "result", "nativeTextGetUnicode", "newDocument", "bytes", "newPageSearch", "Lcom/harissk/pdfium/search/TextSearchContext;", "onAnnotationAdded", "pageNewPtr", "onAnnotationRemoved", "onAnnotationUpdated", "openPage", "prepareTextInfo", "recursiveGetBookmark", "tree", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "(Ljava/util/ArrayList;JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "releaseTextInfo", "renderPage", "drawSizeX", "drawSizeY", "renderPageBitmap", "setCurrentDpi", "d", "setLogWriter", "validPtr", "ptr", "Companion", "pdfium_release"})
@SourceDebugExtension(value={"SMAP\nPdfiumCore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PdfiumCore.kt\ncom/harissk/pdfium/PdfiumCore\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,1026:1\n1#2:1027\n1855#3,2:1028\n1855#3,2:1030\n1855#3,2:1032\n13337#4,2:1034\n13414#4,3:1036\n*S KotlinDebug\n*F\n+ 1 PdfiumCore.kt\ncom/harissk/pdfium/PdfiumCore\n*L\n421#1:1028,2\n426#1:1030,2\n431#1:1032,2\n500#1:1034,2\n678#1:1036,3\n*E\n"})
public final class PdfiumCore
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int mCurrentDpi = 72;
    @NotNull
    private final Map<Integer, Long> mNativePagesPtr = (Map)new ArrayMap();
    @NotNull
    private final Map<Integer, Long> mNativeTextPagesPtr = (Map)new ArrayMap();
    @NotNull
    private final Map<Integer, Long> mNativeSearchHandlePtr = (Map)new ArrayMap();
    private long mNativeDocPtr;
    @Nullable
    private ParcelFileDescriptor mFileDescriptor;
    @Nullable
    private LogWriter logWriter;
    @NotNull
    private static final String TAG = "PdfiumCore";

    private final native long nativeOpenDocument(int var1, String var2);

    private final native long nativeOpenMemDocument(byte[] var1, String var2);

    private final native void nativeCloseDocument(long var1);

    private final native int nativeGetPageCount(long var1);

    private final native long nativeLoadPage(long var1, int var3);

    private final native long[] nativeLoadPages(long var1, int var3, int var4);

    private final native void nativeClosePage(long var1);

    private final native void nativeClosePages(long[] var1);

    private final native int nativeGetPageWidthPixel(long var1, int var3);

    private final native int nativeGetPageHeightPixel(long var1, int var3);

    private final native int nativeGetPageWidthPoint(long var1);

    private final native int nativeGetPageHeightPoint(long var1);

    private final native int nativeGetPageRotation(long var1);

    private final native void nativeRenderPage(long var1, Surface var3, int var4, int var5, int var6, int var7, boolean var8);

    private final native void nativeRenderPageBitmap(long var1, Bitmap var3, int var4, int var5, int var6, int var7, boolean var8);

    private final native Object nativeGetDocumentMetaText(long var1, String var3, Continuation<? super String> var4);

    private final native Object nativeGetFirstChildBookmark(long var1, Long var3, Continuation<? super Long> var4);

    private final native Object nativeGetSiblingBookmark(long var1, long var3, Continuation<? super Long> var5);

    private final native Object nativeGetBookmarkTitle(long var1, Continuation<? super String> var3);

    private final native Object nativeGetBookmarkDestIndex(long var1, long var3, Continuation<? super Long> var5);

    private final native Size nativeGetPageSizeByIndex(long var1, int var3, int var4);

    private final native long[] nativeGetPageLinks(long var1);

    private final native Integer nativeGetDestPageIndex(long var1, long var3);

    private final native String nativeGetLinkURI(long var1, long var3);

    private final native RectF nativeGetLinkRect(long var1);

    private final native Point nativePageCoordinateToDevice(long var1, int var3, int var4, int var5, int var6, int var7, double var8, double var10);

    private final native PointF nativeDeviceCoordinateToPage(long var1, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    private final native long nativeLoadTextPage(long var1, long var3);

    private final native long[] nativeLoadTextPages(long var1, long[] var3);

    private final native void nativeCloseTextPage(long var1);

    private final native void nativeCloseTextPages(long[] var1);

    private final native int nativeTextCountChars(long var1);

    private final native int nativeTextGetText(long var1, int var3, int var4, short[] var5);

    private final native int nativeTextGetUnicode(long var1, int var3);

    private final native double[] nativeTextGetCharBox(long var1, int var3);

    private final native int nativeTextGetCharIndexAtPos(long var1, double var3, double var5, double var7, double var9);

    private final native int nativeTextCountRects(long var1, int var3, int var4);

    private final native double[] nativeTextGetRect(long var1, int var3);

    private final native int nativeTextGetBoundedTextLength(long var1, double var3, double var5, double var7, double var9);

    private final native int nativeTextGetBoundedText(long var1, double var3, double var5, double var7, double var9, short[] var11);

    private final native long nativeSearchStart(long var1, String var3, boolean var4, boolean var5);

    private final native void nativeSearchStop(long var1);

    private final native boolean nativeSearchNext(long var1);

    private final native boolean nativeSearchPrev(long var1);

    private final native int nativeGetCharIndexOfSearchResult(long var1);

    private final native int nativeCountSearchResult(long var1);

    private final native long nativeAddTextAnnotation(long var1, int var3, String var4, int[] var5, int[] var6);

    private final void onAnnotationAdded(int pageIndex, long pageNewPtr) {
    }

    private final void onAnnotationUpdated(int pageIndex, long pageNewPtr) {
    }

    private final void onAnnotationRemoved(int pageIndex, long pageNewPtr) {
    }

    private final native int nativeGetLastError(long var1);

    private final native String nativeGetErrorMessage(int var1);

    public final void newDocument(@NotNull ParcelFileDescriptor fd) throws IOException {
        Intrinsics.checkNotNullParameter((Object)fd, (String)"fd");
        this.newDocument(fd, null);
    }

    public final synchronized long newDocument(@NotNull ParcelFileDescriptor fd, @Nullable String password) throws IOException {
        Intrinsics.checkNotNullParameter((Object)fd, (String)"fd");
        this.mFileDescriptor = fd;
        int numFd = FileUtils.INSTANCE.getNumFd(fd);
        long docPtr = this.nativeOpenDocument(numFd, password);
        if (!this.isValidPointer(docPtr)) {
            int errorCode = this.nativeGetLastError(this.mNativeDocPtr);
            String errorMessage = this.nativeGetErrorMessage(errorCode);
            this.closeDocument();
            throw new IOException("Error opening PDF document. Code: " + errorCode + ", Message: " + errorMessage);
        }
        this.mNativeDocPtr = docPtr;
        return docPtr;
    }

    public final synchronized long newDocument(@NotNull byte[] bytes, @Nullable String password) throws IOException {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        long docPtr = this.nativeOpenMemDocument(bytes, password);
        if (!this.isValidPointer(docPtr)) {
            int errorCode = this.nativeGetLastError(this.mNativeDocPtr);
            String errorMessage = this.nativeGetErrorMessage(errorCode);
            this.closeDocument();
            throw new IOException("Error opening PDF document. Code: " + errorCode + ", Message: " + errorMessage);
        }
        this.mNativeDocPtr = docPtr;
        return docPtr;
    }

    public final int getPageCount() {
        return this.nativeGetPageCount(this.mNativeDocPtr);
    }

    public final long openPage(int pageIndex) throws PageRenderingException {
        long pagePtr = this.nativeLoadPage(this.mNativeDocPtr, pageIndex);
        if (!this.isValidPointer(pagePtr)) {
            int errorCode = this.nativeGetLastError(pagePtr);
            String errorMessage = this.nativeGetErrorMessage(errorCode);
            throw new PageRenderingException(pageIndex, new Throwable("Error loading page. Code: " + errorCode + ", Message: " + errorMessage));
        }
        Integer n = pageIndex;
        Long l = pagePtr;
        this.mNativePagesPtr.put(n, l);
        this.prepareTextInfo(pageIndex);
        return pagePtr;
    }

    @NotNull
    public final long[] openPage(int fromIndex, int toIndex) {
        long[] pagesPtr = this.nativeLoadPages(this.mNativeDocPtr, fromIndex, toIndex);
        int pageIndex = fromIndex;
        int n = pagesPtr.length;
        for (int i = 0; i < n; ++i) {
            long page = pagesPtr[i];
            if (pageIndex > toIndex) break;
            Integer n2 = pageIndex;
            Long l = page;
            this.mNativePagesPtr.put(n2, l);
            this.prepareTextInfo(++pageIndex);
        }
        return pagesPtr;
    }

    public final int getPageWidth(int index) {
        int n;
        Long l = this.mNativePagesPtr.get(index);
        if (l != null) {
            long it = ((Number)l).longValue();
            boolean bl = false;
            n = this.nativeGetPageWidthPixel(it, this.mCurrentDpi);
        } else {
            n = 0;
        }
        return n;
    }

    public final int getPageHeight(int index) {
        int n;
        Long l = this.mNativePagesPtr.get(index);
        if (l != null) {
            long it = ((Number)l).longValue();
            boolean bl = false;
            n = this.nativeGetPageHeightPixel(it, this.mCurrentDpi);
        } else {
            n = 0;
        }
        return n;
    }

    public final int getPageWidthPoint(int index) {
        int n;
        Long l = this.mNativePagesPtr.get(index);
        if (l != null) {
            long it = ((Number)l).longValue();
            boolean bl = false;
            n = this.nativeGetPageWidthPoint(it);
        } else {
            n = 0;
        }
        return n;
    }

    public final int getPageHeightPoint(int index) {
        int n;
        Long l = this.mNativePagesPtr.get(index);
        if (l != null) {
            long it = ((Number)l).longValue();
            boolean bl = false;
            n = this.nativeGetPageHeightPoint(it);
        } else {
            n = 0;
        }
        return n;
    }

    @NotNull
    public final Size getPageSize(int index) {
        return this.nativeGetPageSizeByIndex(this.mNativeDocPtr, index, this.mCurrentDpi);
    }

    public final int getPageRotation(int index) {
        int n;
        Long l = this.mNativePagesPtr.get(index);
        if (l != null) {
            long it = ((Number)l).longValue();
            boolean bl = false;
            n = this.nativeGetPageRotation(it);
        } else {
            n = 0;
        }
        return n;
    }

    public final void renderPage(@NotNull Surface surface, int pageIndex, int startX, int startY, int drawSizeX, int drawSizeY, boolean renderAnnot) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
            try {
                Long l = this.mNativePagesPtr.get(pageIndex);
                if (l == null) {
                    throw new NullPointerException();
                }
                this.nativeRenderPage(l, surface, startX, startY, drawSizeX, drawSizeY, renderAnnot);
            }
            catch (NullPointerException e) {
                LogWriter logWriter = this.logWriter;
                if (logWriter == null) break block4;
                logWriter.writeLog("mContext may be null", TAG);
            }
            catch (Exception e) {
                LogWriter logWriter = this.logWriter;
                if (logWriter == null) break block4;
                logWriter.writeLog("Exception throw from native", TAG);
            }
        }
    }

    public static /* synthetic */ void renderPage$default(PdfiumCore pdfiumCore, Surface surface, int n, int n2, int n3, int n4, int n5, boolean bl, int n6, Object object) {
        if ((n6 & 0x40) != 0) {
            bl = false;
        }
        pdfiumCore.renderPage(surface, n, n2, n3, n4, n5, bl);
    }

    public final void renderPageBitmap(@NotNull Bitmap bitmap, int pageIndex, int startX, int startY, int drawSizeX, int drawSizeY, boolean renderAnnot) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
            try {
                Long l = this.mNativePagesPtr.get(pageIndex);
                if (l == null) {
                    throw new NullPointerException();
                }
                this.nativeRenderPageBitmap(l, bitmap, startX, startY, drawSizeX, drawSizeY, renderAnnot);
            }
            catch (NullPointerException e) {
                LogWriter logWriter = this.logWriter;
                if (logWriter == null) break block4;
                logWriter.writeLog("mContext may be null", TAG);
            }
            catch (Exception e) {
                LogWriter logWriter = this.logWriter;
                if (logWriter == null) break block4;
                logWriter.writeLog("Exception throw from native", TAG);
            }
        }
    }

    public static /* synthetic */ void renderPageBitmap$default(PdfiumCore pdfiumCore, Bitmap bitmap, int n, int n2, int n3, int n4, int n5, boolean bl, int n6, Object object) {
        if ((n6 & 0x40) != 0) {
            bl = false;
        }
        pdfiumCore.renderPageBitmap(bitmap, n, n2, n3, n4, n5, bl);
    }

    public final void closePage(int pageIndex) {
        Long l = this.mNativePagesPtr.get(pageIndex);
        if (l == null) {
            throw new NullPointerException();
        }
        long pagePtr = l;
        this.nativeClosePage(pagePtr);
        this.mNativePagesPtr.remove(pageIndex);
    }

    public final synchronized int getLastError(long docPtr) {
        return this.nativeGetLastError(docPtr);
    }

    @NotNull
    public final synchronized String getErrorMessage(int errorCode) {
        return this.nativeGetErrorMessage(errorCode);
    }

    @Override
    public synchronized void close() {
        this.closeDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized void closeDocument() {
        try {
            Iterable $this$forEach$iv = this.mNativePagesPtr.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                long pagePtr = ((Number)element$iv).longValue();
                boolean bl = false;
                if (!this.isValidPointer(pagePtr)) continue;
                this.nativeClosePage(pagePtr);
            }
            $this$forEach$iv = this.mNativeTextPagesPtr.values();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                long textPagePtr = ((Number)element$iv).longValue();
                boolean bl = false;
                if (!this.isValidPointer(textPagePtr)) continue;
                this.nativeCloseTextPage(textPagePtr);
            }
            $this$forEach$iv = this.mNativeSearchHandlePtr.values();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                long searchHandle = ((Number)element$iv).longValue();
                boolean bl = false;
                if (!this.isValidPointer(searchHandle)) continue;
                this.nativeSearchStop(searchHandle);
            }
            this.nativeCloseDocument(this.mNativeDocPtr);
        }
        finally {
            this.mNativePagesPtr.clear();
            this.mNativeTextPagesPtr.clear();
            this.mNativeSearchHandlePtr.clear();
            this.mNativeDocPtr = 0L;
            try {
                ParcelFileDescriptor parcelFileDescriptor = this.mFileDescriptor;
                if (parcelFileDescriptor != null) {
                    parcelFileDescriptor.close();
                }
            }
            catch (IOException e) {
                LogWriter logWriter = this.logWriter;
                if (logWriter != null) {
                    LogWriter.DefaultImpls.writeLog$default(logWriter, e, null, 2, null);
                }
            }
            finally {
                this.mFileDescriptor = null;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object getDocumentMeta(@NotNull Continuation<? super Meta> var1_1) {
        if (!(var1_1 instanceof getDocumentMeta.1)) ** GOTO lbl-1000
        var11_2 = var1_1;
        if ((var11_2.label & -2147483648) != 0) {
            var11_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                /* synthetic */ Object result;
                final /* synthetic */ PdfiumCore this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getDocumentMeta((Continuation<? super Meta>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var20_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.nativeGetDocumentMetaText(this.mNativeDocPtr, "Title", (Continuation<? super String>)$continuation);
                if (v0 == var20_4) {
                    return var20_4;
                }
                ** GOTO lbl23
            }
            case 1: {
                this = (PdfiumCore)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl23:
                // 2 sources

                if ((v1 = (String)v0) == null) {
                    v1 = "";
                }
                var2_5 = v1;
                $continuation.L$0 = this;
                $continuation.L$1 = var2_5;
                $continuation.label = 2;
                v2 = this.nativeGetDocumentMetaText(this.mNativeDocPtr, "Author", (Continuation<? super String>)$continuation);
                if (v2 == var20_4) {
                    return var20_4;
                }
                ** GOTO lbl38
            }
            case 2: {
                var2_5 = (String)$continuation.L$1;
                this = (PdfiumCore)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl38:
                // 2 sources

                if ((v3 = (String)v2) == null) {
                    v3 = "";
                }
                var3_6 = v3;
                $continuation.L$0 = this;
                $continuation.L$1 = var2_5;
                $continuation.L$2 = var3_6;
                $continuation.label = 3;
                v4 = this.nativeGetDocumentMetaText(this.mNativeDocPtr, "Subject", (Continuation<? super String>)$continuation);
                if (v4 == var20_4) {
                    return var20_4;
                }
                ** GOTO lbl55
            }
            case 3: {
                var3_6 = (String)$continuation.L$2;
                var2_5 = (String)$continuation.L$1;
                this = (PdfiumCore)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl55:
                // 2 sources

                if ((v5 = (String)(var4_7 = v4)) == null) {
                    v5 = "";
                }
                var4_7 = v5;
                $continuation.L$0 = this;
                $continuation.L$1 = var2_5;
                $continuation.L$2 = var3_6;
                $continuation.L$3 = var4_7;
                $continuation.label = 4;
                v6 = this.nativeGetDocumentMetaText(this.mNativeDocPtr, "Keywords", (Continuation<? super String>)$continuation);
                if (v6 == var20_4) {
                    return var20_4;
                }
                ** GOTO lbl74
            }
            case 4: {
                var4_7 = (String)$continuation.L$3;
                var3_6 = (String)$continuation.L$2;
                var2_5 = (String)$continuation.L$1;
                this = (PdfiumCore)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v6 = $result;
lbl74:
                // 2 sources

                if ((v7 = (String)(var5_8 = v6)) == null) {
                    v7 = "";
                }
                var5_8 = v7;
                $continuation.L$0 = this;
                $continuation.L$1 = var2_5;
                $continuation.L$2 = var3_6;
                $continuation.L$3 = var4_7;
                $continuation.L$4 = var5_8;
                $continuation.label = 5;
                v8 = this.nativeGetDocumentMetaText(this.mNativeDocPtr, "Creator", (Continuation<? super String>)$continuation);
                if (v8 == var20_4) {
                    return var20_4;
                }
                ** GOTO lbl95
            }
            case 5: {
                var5_8 = (String)$continuation.L$4;
                var4_7 = (String)$continuation.L$3;
                var3_6 = (String)$continuation.L$2;
                var2_5 = (String)$continuation.L$1;
                this = (PdfiumCore)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v8 = $result;
lbl95:
                // 2 sources

                if ((v9 = (String)(var6_9 = v8)) == null) {
                    v9 = "";
                }
                var6_9 = v9;
                $continuation.L$0 = this;
                $continuation.L$1 = var2_5;
                $continuation.L$2 = var3_6;
                $continuation.L$3 = var4_7;
                $continuation.L$4 = var5_8;
                $continuation.L$5 = var6_9;
                $continuation.label = 6;
                v10 = this.nativeGetDocumentMetaText(this.mNativeDocPtr, "Producer", (Continuation<? super String>)$continuation);
                if (v10 == var20_4) {
                    return var20_4;
                }
                ** GOTO lbl118
            }
            case 6: {
                var6_9 = (String)$continuation.L$5;
                var5_8 = (String)$continuation.L$4;
                var4_7 = (String)$continuation.L$3;
                var3_6 = (String)$continuation.L$2;
                var2_5 = (String)$continuation.L$1;
                this = (PdfiumCore)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v10 = $result;
lbl118:
                // 2 sources

                if ((v11 = (String)(var7_10 = v10)) == null) {
                    v11 = "";
                }
                var7_10 = v11;
                $continuation.L$0 = this;
                $continuation.L$1 = var2_5;
                $continuation.L$2 = var3_6;
                $continuation.L$3 = var4_7;
                $continuation.L$4 = var5_8;
                $continuation.L$5 = var6_9;
                $continuation.L$6 = var7_10;
                $continuation.label = 7;
                v12 = this.nativeGetDocumentMetaText(this.mNativeDocPtr, "CreationDate", (Continuation<? super String>)$continuation);
                if (v12 == var20_4) {
                    return var20_4;
                }
                ** GOTO lbl143
            }
            case 7: {
                var7_10 = (String)$continuation.L$6;
                var6_9 = (String)$continuation.L$5;
                var5_8 = (String)$continuation.L$4;
                var4_7 = (String)$continuation.L$3;
                var3_6 = (String)$continuation.L$2;
                var2_5 = (String)$continuation.L$1;
                this = (PdfiumCore)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v12 = $result;
lbl143:
                // 2 sources

                if ((v13 = (String)(var8_11 = v12)) == null) {
                    v13 = "";
                }
                var8_11 = v13;
                $continuation.L$0 = var2_5;
                $continuation.L$1 = var3_6;
                $continuation.L$2 = var4_7;
                $continuation.L$3 = var5_8;
                $continuation.L$4 = var6_9;
                $continuation.L$5 = var7_10;
                $continuation.L$6 = var8_11;
                $continuation.label = 8;
                v14 = this.nativeGetDocumentMetaText(this.mNativeDocPtr, "ModDate", (Continuation<? super String>)$continuation);
                if (v14 == var20_4) {
                    return var20_4;
                }
                ** GOTO lbl168
            }
            case 8: {
                var8_11 = (String)$continuation.L$6;
                var7_10 = (String)$continuation.L$5;
                var6_9 = (String)$continuation.L$4;
                var5_8 = (String)$continuation.L$3;
                var4_7 = (String)$continuation.L$2;
                var3_6 = (String)$continuation.L$1;
                var2_5 = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v14 = $result;
lbl168:
                // 2 sources

                if ((v15 = (String)(var9_12 = v14)) == null) {
                    v15 = "";
                }
                var12_13 = v15;
                var13_14 = var8_11;
                var14_15 = var7_10;
                var15_16 = var6_9;
                var16_17 = var5_8;
                var17_18 = var4_7;
                var18_19 = var3_6;
                var19_20 = var2_5;
                return new Meta(var19_20, var18_19, (String)var17_18, (String)var16_17, (String)var15_16, (String)var14_15, (String)var13_14, var12_13);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object getTableOfContents(@NotNull Continuation<? super List<Bookmark>> var1_1) {
        if (!(var1_1 instanceof getTableOfContents.1)) ** GOTO lbl-1000
        var7_2 = var1_1;
        if ((var7_2.label & -2147483648) != 0) {
            var7_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ PdfiumCore this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getTableOfContents((Continuation<? super List<Bookmark>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                topLevel = new ArrayList();
                $continuation.L$0 = this;
                $continuation.L$1 = topLevel;
                $continuation.label = 1;
                v0 = this.nativeGetFirstChildBookmark(this.mNativeDocPtr, null, (Continuation<? super Long>)$continuation);
                if (v0 == var8_4) {
                    return var8_4;
                }
                ** GOTO lbl25
            }
            case 1: {
                topLevel = (ArrayList)$continuation.L$1;
                this = (PdfiumCore)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl25:
                // 2 sources

                v1 = (Long)v0;
                if (v1 == null) break;
                it = ((Number)v1).longValue();
                $i$a$-let-PdfiumCore$getTableOfContents$2 = false;
                $continuation.L$0 = topLevel;
                $continuation.L$1 = null;
                $continuation.label = 2;
                v2 = this.recursiveGetBookmark(topLevel, it, (Continuation<? super Unit>)$continuation);
                if (v2 == var8_4) {
                    return var8_4;
                }
                break;
            }
            case 2: {
                $i$a$-let-PdfiumCore$getTableOfContents$2 = false;
                topLevel = (ArrayList)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
                break;
            }
        }
        return topLevel;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object recursiveGetBookmark(ArrayList<Bookmark> var1_1, long var2_2, Continuation<? super Unit> var4_3) {
        block19: {
            if (!(var4_3 instanceof recursiveGetBookmark.1)) ** GOTO lbl-1000
            var12_4 = var4_3;
            if ((var12_4.label & -2147483648) != 0) {
                var12_4.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var4_3){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    long J$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ PdfiumCore this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return PdfiumCore.access$recursiveGetBookmark(this.this$0, null, 0L, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var13_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $continuation.L$0 = this;
                    $continuation.L$1 = tree;
                    $continuation.J$0 = bookmarkPtr;
                    $continuation.label = 1;
                    v0 = this.nativeGetBookmarkTitle(bookmarkPtr, (Continuation<? super String>)$continuation);
                    if (v0 == var13_6) {
                        return var13_6;
                    }
                    ** GOTO lbl26
                }
                case 1: {
                    bookmarkPtr = $continuation.J$0;
                    tree = (ArrayList)$continuation.L$1;
                    this = (PdfiumCore)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl26:
                    // 2 sources

                    if ((v1 = (String)v0) == null) {
                        v1 = "";
                    }
                    var6_7 = v1;
                    $continuation.L$0 = this;
                    $continuation.L$1 = tree;
                    $continuation.L$2 = var6_7;
                    $continuation.J$0 = bookmarkPtr;
                    $continuation.label = 2;
                    v2 = this.nativeGetBookmarkDestIndex(this.mNativeDocPtr, bookmarkPtr, (Continuation<? super Long>)$continuation);
                    if (v2 == var13_6) {
                        return var13_6;
                    }
                    ** GOTO lbl45
                }
                case 2: {
                    bookmarkPtr = $continuation.J$0;
                    var6_7 = (String)$continuation.L$2;
                    tree = (ArrayList)$continuation.L$1;
                    this = (PdfiumCore)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl45:
                    // 2 sources

                    var7_8 = ((Number)v2).longValue();
                    var9_9 = new ArrayList<Bookmark>();
                    bookmark = new Bookmark(var6_7, var7_8, var9_9, bookmarkPtr);
                    tree.add(bookmark);
                    $continuation.L$0 = this;
                    $continuation.L$1 = tree;
                    $continuation.L$2 = bookmark;
                    $continuation.J$0 = bookmarkPtr;
                    $continuation.label = 3;
                    v3 = this.nativeGetFirstChildBookmark(this.mNativeDocPtr, Boxing.boxLong((long)bookmarkPtr), (Continuation<? super Long>)$continuation);
                    if (v3 == var13_6) {
                        return var13_6;
                    }
                    ** GOTO lbl66
                }
                case 3: {
                    bookmarkPtr = $continuation.J$0;
                    bookmark = (Bookmark)$continuation.L$2;
                    tree = (ArrayList)$continuation.L$1;
                    this = (PdfiumCore)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl66:
                    // 2 sources

                    v4 = (Long)v3;
                    if (v4 == null) break;
                    child = ((Number)v4).longValue();
                    $i$a$-let-PdfiumCore$recursiveGetBookmark$2 = false;
                    $continuation.L$0 = this;
                    $continuation.L$1 = tree;
                    $continuation.L$2 = null;
                    $continuation.J$0 = bookmarkPtr;
                    $continuation.label = 4;
                    v5 = this.recursiveGetBookmark(bookmark.getChildren(), child, (Continuation<? super Unit>)$continuation);
                    if (v5 == var13_6) {
                        return var13_6;
                    }
                    break;
                }
                case 4: {
                    $i$a$-let-PdfiumCore$recursiveGetBookmark$2 = false;
                    bookmarkPtr = $continuation.J$0;
                    tree = (ArrayList)$continuation.L$1;
                    this = (PdfiumCore)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v5 = $result;
                    break;
                }
            }
            $continuation.L$0 = this;
            $continuation.L$1 = tree;
            $continuation.L$2 = null;
            $continuation.label = 5;
            v6 = this.nativeGetSiblingBookmark(this.mNativeDocPtr, bookmarkPtr, (Continuation<? super Long>)$continuation);
            if (v6 == var13_6) {
                return var13_6;
            }
            ** GOTO lbl103
            {
                case 5: {
                    tree = (ArrayList)$continuation.L$1;
                    this = (PdfiumCore)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v6 = $result;
lbl103:
                    // 2 sources

                    v7 = (Long)v6;
                    if (v7 == null) break;
                    sibling = ((Number)v7).longValue();
                    $i$a$-let-PdfiumCore$recursiveGetBookmark$3 = false;
                    $continuation.L$0 = null;
                    $continuation.L$1 = null;
                    $continuation.label = 6;
                    v8 = this.recursiveGetBookmark(tree, sibling, (Continuation<? super Unit>)$continuation);
                    if (v8 == var13_6) {
                        return var13_6;
                    }
                    break block19;
                }
                case 6: {
                    $i$a$-let-PdfiumCore$recursiveGetBookmark$3 = false;
                    ResultKt.throwOnFailure((Object)$result);
                    v8 = $result;
                    break block19;
                }
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public final List<Link> getPageLinks(int pageIndex) {
        if (pageIndex < 0) {
            return CollectionsKt.emptyList();
        }
        List links = new ArrayList();
        Long l = this.mNativePagesPtr.get(pageIndex);
        if (l == null) {
            return links;
        }
        long nativePagePtr = l;
        long[] $this$forEach$iv = this.nativeGetPageLinks(nativePagePtr);
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            RectF rect;
            long element$iv;
            long linkPtr = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            Integer index = this.nativeGetDestPageIndex(this.mNativeDocPtr, linkPtr);
            String uri = this.nativeGetLinkURI(this.mNativeDocPtr, linkPtr);
            if (this.nativeGetLinkRect(linkPtr) == null || index == null && uri == null) continue;
            links.add(new Link(rect, index, uri));
        }
        return links;
    }

    private final Point mapPageCoordinatesToDevice(int pageIndex, int startX, int startY, int sizeX, int sizeY, int rotate, double pageX, double pageY) {
        Long l = this.mNativePagesPtr.get(pageIndex);
        if (l == null) {
            return new Point();
        }
        long pagePtr = l;
        return this.nativePageCoordinateToDevice(pagePtr, startX, startY, sizeX, sizeY, rotate, pageX, pageY);
    }

    @NotNull
    public final PointF mapDeviceCoordinateToPage(int pageIndex, int startX, int startY, int sizeX, int sizeY, int rotate, int deviceX, int deviceY) {
        Long l = this.mNativePagesPtr.get(pageIndex);
        if (l == null) {
            return new PointF();
        }
        long pagePtr = l;
        return this.nativeDeviceCoordinateToPage(pagePtr, startX, startY, sizeX, sizeY, rotate, deviceX, deviceY);
    }

    @NotNull
    public final RectF mapPageCoordinateToDevice(int pageIndex, int startX, int startY, int sizeX, int sizeY, int rotate, @NotNull RectF coords) {
        Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
        Point leftTop = this.mapPageCoordinatesToDevice(pageIndex, startX, startY, sizeX, sizeY, rotate, coords.left, coords.top);
        Point rightBottom = this.mapPageCoordinatesToDevice(pageIndex, startX, startY, sizeX, sizeY, rotate, coords.right, coords.bottom);
        return new RectF((float)leftTop.x, (float)leftTop.y, (float)rightBottom.x, (float)rightBottom.y);
    }

    public final long prepareTextInfo(int pageIndex) {
        Long pagePtr = this.mNativePagesPtr.get(pageIndex);
        if (!this.isValidPointer(pagePtr)) {
            throw new IllegalStateException("Page at index " + pageIndex + " not open. Ensure page is opened before preparing text info.");
        }
        Long l = pagePtr;
        Intrinsics.checkNotNull((Object)l);
        long textPagePtr = this.nativeLoadTextPage(this.mNativeDocPtr, l);
        if (this.isValidPointer(textPagePtr)) {
            Integer n = pageIndex;
            Long l2 = textPagePtr;
            this.mNativeTextPagesPtr.put(n, l2);
        }
        return textPagePtr;
    }

    public final void releaseTextInfo(int pageIndex) {
        Long textPagePtr = this.mNativeTextPagesPtr.get(pageIndex);
        if (this.validPtr(textPagePtr)) {
            Long l = textPagePtr;
            this.nativeCloseTextPage(l != null ? l : 0L);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final long[] prepareTextInfo(int fromIndex, int toIndex) {
        long[] resultTextPagesPtrArray;
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex cannot be greater than toIndex.");
        }
        List pagePtrsList = new ArrayList();
        int i = fromIndex;
        if (i <= toIndex) {
            while (true) {
                Long pagePtr;
                if (!this.isValidPointer(pagePtr = this.mNativePagesPtr.get(i))) {
                    throw new IllegalStateException("Page at index " + i + " not open. Ensure all pages in range are opened before preparing text info.");
                }
                Long l = pagePtr;
                Intrinsics.checkNotNull((Object)l);
                pagePtrsList.add(l);
                if (i == toIndex) break;
                ++i;
            }
        }
        long[] pagePtrsArray = CollectionsKt.toLongArray((Collection)pagePtrsList);
        long[] $this$forEachIndexed$iv = resultTextPagesPtrArray = this.nativeLoadTextPages(this.mNativeDocPtr, pagePtrsArray);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (long item$iv : $this$forEachIndexed$iv) {
            void textPagePtr;
            int n = index$iv++;
            long l = item$iv;
            int resultIndex = n;
            boolean bl = false;
            int originalPageIndex = fromIndex + resultIndex;
            if (originalPageIndex > toIndex || !this.isValidPointer((long)textPagePtr)) continue;
            Integer n2 = originalPageIndex;
            Long l2 = (long)textPagePtr;
            this.mNativeTextPagesPtr.put(n2, l2);
        }
        return resultTextPagesPtrArray;
    }

    public final void releaseTextInfo(int fromIndex, int toIndex) {
        int i = fromIndex;
        if (i <= toIndex) {
            while (true) {
                Long textPagePtr;
                if (this.validPtr(textPagePtr = this.mNativeTextPagesPtr.get(i))) {
                    Long l = textPagePtr;
                    this.nativeCloseTextPage(l != null ? l : 0L);
                }
                if (i == toIndex) break;
                ++i;
            }
        }
    }

    private final long ensureTextPage(int pageIndex) {
        Long ptr = this.mNativeTextPagesPtr.get(pageIndex);
        if (this.validPtr(ptr)) {
            Long l = ptr;
            return l != null ? l : 0L;
        }
        return this.prepareTextInfo(pageIndex);
    }

    public final int countCharactersOnPage(int pageIndex) {
        int n;
        try {
            long ptr = this.ensureTextPage(pageIndex);
            n = this.validPtr(ptr) ? this.nativeTextCountChars(ptr) : 0;
        }
        catch (Exception e) {
            LogWriter logWriter = this.logWriter;
            if (logWriter != null) {
                logWriter.writeLog("Error counting characters on page", TAG);
            }
            n = 0;
        }
        return n;
    }

    @Nullable
    public final String extractCharacters(int pageIndex, int startIndex, int length) {
        String string;
        try {
            String string2;
            long ptr = this.ensureTextPage(pageIndex);
            if (this.validPtr(ptr)) {
                short[] buf = new short[length + 1];
                int r = this.nativeTextGetText(ptr, startIndex, length, buf);
                byte[] bytes = new byte[(r - 1) * 2];
                ByteBuffer bb = ByteBuffer.wrap(bytes);
                bb.order(ByteOrder.LITTLE_ENDIAN);
                int n = r - 1;
                for (int i = 0; i < n; ++i) {
                    bb.putShort(buf[i]);
                }
                Charset charset = Charset.forName("UTF-16LE");
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
                string2 = new String(bytes, charset);
            } else {
                string2 = null;
            }
            string = string2;
        }
        catch (Exception e) {
            LogWriter logWriter = this.logWriter;
            if (logWriter != null) {
                logWriter.writeLog("Error extracting characters from page", TAG);
            }
            string = null;
        }
        return string;
    }

    public final char extractCharacter(int pageIndex, int index) {
        int n;
        try {
            long ptr = this.ensureTextPage(pageIndex);
            n = this.validPtr(ptr) ? this.nativeTextGetUnicode(ptr, index) : 0;
        }
        catch (Exception e) {
            LogWriter logWriter = this.logWriter;
            if (logWriter != null) {
                logWriter.writeLog("Error extracting character from page", TAG);
            }
            n = 0;
        }
        return (char)n;
    }

    @Nullable
    public final RectF measureCharacterBox(int pageIndex, int index) {
        RectF rectF;
        try {
            RectF rectF2;
            long ptr = this.ensureTextPage(pageIndex);
            if (this.validPtr(ptr)) {
                double[] o = this.nativeTextGetCharBox(ptr, index);
                rectF2 = new RectF((float)o[0], (float)o[3], (float)o[1], (float)o[2]);
            } else {
                rectF2 = null;
            }
            rectF = rectF2;
        }
        catch (Exception e) {
            LogWriter logWriter = this.logWriter;
            if (logWriter != null) {
                logWriter.writeLog("Error measuring character box", TAG);
            }
            rectF = null;
        }
        return rectF;
    }

    public final int getCharacterIndex(int pageIndex, double x, double y, double xTolerance, double yTolerance) {
        int n;
        try {
            long ptr = this.ensureTextPage(pageIndex);
            n = this.validPtr(ptr) ? this.nativeTextGetCharIndexAtPos(ptr, x, y, xTolerance, yTolerance) : -1;
        }
        catch (Exception e) {
            LogWriter logWriter = this.logWriter;
            if (logWriter != null) {
                logWriter.writeLog("Error getting character index", TAG);
            }
            n = -1;
        }
        return n;
    }

    public final int countTextRect(int pageIndex, int charIndex, int count) {
        int n;
        try {
            long ptr = this.ensureTextPage(pageIndex);
            n = this.validPtr(ptr) ? this.nativeTextCountRects(ptr, charIndex, count) : -1;
        }
        catch (Exception e) {
            LogWriter logWriter = this.logWriter;
            if (logWriter != null) {
                logWriter.writeLog("Error counting text rectangles", TAG);
            }
            n = -1;
        }
        return n;
    }

    @Nullable
    public final RectF getTextRect(int pageIndex, int rectIndex) {
        RectF rectF;
        try {
            RectF rectF2;
            long ptr = this.ensureTextPage(pageIndex);
            if (this.validPtr(ptr)) {
                double[] o = this.nativeTextGetRect(ptr, rectIndex);
                rectF2 = new RectF((float)o[0], (float)o[1], (float)o[2], (float)o[3]);
            } else {
                rectF2 = null;
            }
            rectF = rectF2;
        }
        catch (Exception e) {
            LogWriter logWriter = this.logWriter;
            if (logWriter != null) {
                logWriter.writeLog("Error getting text rectangle", TAG);
            }
            rectF = null;
        }
        return rectF;
    }

    @Nullable
    public final String extractText(int pageIndex, @NotNull RectF rect) {
        String string;
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        try {
            long ptr = this.ensureTextPage(pageIndex);
            if (!this.validPtr(ptr)) {
                return null;
            }
            int length = this.nativeTextGetBoundedTextLength(ptr, rect.left, rect.top, rect.right, rect.bottom);
            if (length <= 0) {
                return null;
            }
            short[] buf = new short[length + 1];
            int r = this.nativeTextGetBoundedText(ptr, rect.left, rect.top, rect.right, rect.bottom, buf);
            byte[] bytes = new byte[(r - 1) * 2];
            ByteBuffer bb = ByteBuffer.wrap(bytes);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            int n = r - 1;
            for (int i = 0; i < n; ++i) {
                bb.putShort(buf[i]);
            }
            Charset charset = Charset.forName("UTF-16LE");
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
            string = new String(bytes, charset);
        }
        catch (Exception e) {
            LogWriter logWriter = this.logWriter;
            if (logWriter != null) {
                logWriter.writeLog("Error extracting text", TAG);
            }
            string = null;
        }
        return string;
    }

    @NotNull
    public final TextSearchContext newPageSearch(int pageIndex, @NotNull String query, boolean matchCase, boolean matchWholeWord) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        return new FPDFTextSearchContext(pageIndex, query, matchCase, matchWholeWord, this){
            @Nullable
            private Long mSearchHandlePtr;
            final /* synthetic */ int $pageIndex;
            final /* synthetic */ String $query;
            final /* synthetic */ boolean $matchCase;
            final /* synthetic */ boolean $matchWholeWord;
            final /* synthetic */ PdfiumCore this$0;
            {
                this.$pageIndex = $pageIndex;
                this.$query = $query;
                this.$matchCase = $matchCase;
                this.$matchWholeWord = $matchWholeWord;
                this.this$0 = $receiver;
                super($pageIndex, $query, $matchCase, $matchWholeWord);
            }

            public void prepareSearch() {
                Long oldSearchHandle;
                long textPage = this.this$0.prepareTextInfo(this.$pageIndex);
                if (this.this$0.hasSearchHandle(this.$pageIndex) && PdfiumCore.access$isValidPointer(this.this$0, oldSearchHandle = (Long)PdfiumCore.access$getMNativeSearchHandlePtr$p(this.this$0).remove(this.$pageIndex))) {
                    Long l = oldSearchHandle;
                    Intrinsics.checkNotNull((Object)l);
                    PdfiumCore.access$nativeSearchStop(this.this$0, l);
                }
                this.mSearchHandlePtr = PdfiumCore.access$nativeSearchStart(this.this$0, textPage, this.$query, this.$matchCase, this.$matchWholeWord);
                if (PdfiumCore.access$isValidPointer(this.this$0, this.mSearchHandlePtr)) {
                    Map map = PdfiumCore.access$getMNativeSearchHandlePtr$p(this.this$0);
                    Integer n = this.$pageIndex;
                    Long l = this.mSearchHandlePtr;
                    Intrinsics.checkNotNull((Object)l);
                    map.put(n, l);
                }
            }

            public int getCountResult() {
                int n;
                if (PdfiumCore.access$isValidPointer(this.this$0, this.mSearchHandlePtr)) {
                    Long l = this.mSearchHandlePtr;
                    Intrinsics.checkNotNull((Object)l);
                    n = PdfiumCore.access$nativeCountSearchResult(this.this$0, l);
                } else {
                    n = -1;
                }
                return n;
            }

            @Nullable
            public RectF getSearchNext() {
                if (PdfiumCore.access$isValidPointer(this.this$0, this.mSearchHandlePtr)) {
                    Long l = this.mSearchHandlePtr;
                    Intrinsics.checkNotNull((Object)l);
                    this.setMHasNext(PdfiumCore.access$nativeSearchNext(this.this$0, l));
                    if (this.getMHasNext()) {
                        Long l2 = this.mSearchHandlePtr;
                        Intrinsics.checkNotNull((Object)l2);
                        int index = PdfiumCore.access$nativeGetCharIndexOfSearchResult(this.this$0, l2);
                        if (index > -1) {
                            return this.this$0.measureCharacterBox(this.getPageIndex(), index);
                        }
                    }
                }
                this.setMHasNext(false);
                return null;
            }

            @Nullable
            public RectF getSearchPrev() {
                if (PdfiumCore.access$isValidPointer(this.this$0, this.mSearchHandlePtr)) {
                    Long l = this.mSearchHandlePtr;
                    Intrinsics.checkNotNull((Object)l);
                    this.setMHasPrev(PdfiumCore.access$nativeSearchPrev(this.this$0, l));
                    if (this.getMHasPrev()) {
                        Long l2 = this.mSearchHandlePtr;
                        Intrinsics.checkNotNull((Object)l2);
                        int index = PdfiumCore.access$nativeGetCharIndexOfSearchResult(this.this$0, l2);
                        if (index > -1) {
                            return this.this$0.measureCharacterBox(this.getPageIndex(), index);
                        }
                    }
                }
                this.setMHasPrev(false);
                return null;
            }

            public void stopSearch() {
                super.stopSearch();
                if (PdfiumCore.access$isValidPointer(this.this$0, this.mSearchHandlePtr)) {
                    Long l = this.mSearchHandlePtr;
                    Intrinsics.checkNotNull((Object)l);
                    PdfiumCore.access$nativeSearchStop(this.this$0, l);
                    PdfiumCore.access$getMNativeSearchHandlePtr$p(this.this$0).remove(this.$pageIndex);
                    this.mSearchHandlePtr = null;
                }
            }
        };
    }

    public final int getCurrentDpi() {
        return this.mCurrentDpi;
    }

    public final void setCurrentDpi(int d) {
        this.mCurrentDpi = d;
    }

    public final boolean hasPage(int index) {
        return this.mNativePagesPtr.containsKey(index);
    }

    public final boolean hasTextPage(int index) {
        return this.mNativeTextPagesPtr.containsKey(index);
    }

    public final boolean hasSearchHandle(int index) {
        return this.mNativeSearchHandlePtr.containsKey(index);
    }

    public final void setLogWriter(@NotNull LogWriter logWriter) {
        Intrinsics.checkNotNullParameter((Object)logWriter, (String)"logWriter");
        this.logWriter = logWriter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean validPtr(Long ptr) {
        if (ptr == null) return false;
        long l = -1L;
        if (ptr == l) return false;
        l = 0L;
        if (ptr == l) return false;
        return true;
    }

    private final boolean validPtr(long ptr) {
        return ptr != 0L && ptr != -1L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isValidPointer(Long pointer) {
        if (pointer == null) return false;
        long l = 0L;
        if (pointer == l) return false;
        l = -1L;
        if (pointer == l) return false;
        return true;
    }

    public static final /* synthetic */ Object access$recursiveGetBookmark(PdfiumCore $this, ArrayList tree, long bookmarkPtr, Continuation $completion) {
        return $this.recursiveGetBookmark(tree, bookmarkPtr, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Map access$getMNativeSearchHandlePtr$p(PdfiumCore $this) {
        return $this.mNativeSearchHandlePtr;
    }

    public static final /* synthetic */ boolean access$isValidPointer(PdfiumCore $this, Long pointer) {
        return $this.isValidPointer(pointer);
    }

    public static final /* synthetic */ void access$nativeSearchStop(PdfiumCore $this, long searchHandlePtr) {
        $this.nativeSearchStop(searchHandlePtr);
    }

    public static final /* synthetic */ long access$nativeSearchStart(PdfiumCore $this, long textPagePtr, String query, boolean matchCase, boolean matchWholeWord) {
        return $this.nativeSearchStart(textPagePtr, query, matchCase, matchWholeWord);
    }

    public static final /* synthetic */ int access$nativeCountSearchResult(PdfiumCore $this, long searchHandlePtr) {
        return $this.nativeCountSearchResult(searchHandlePtr);
    }

    public static final /* synthetic */ boolean access$nativeSearchNext(PdfiumCore $this, long searchHandlePtr) {
        return $this.nativeSearchNext(searchHandlePtr);
    }

    public static final /* synthetic */ int access$nativeGetCharIndexOfSearchResult(PdfiumCore $this, long searchHandlePtr) {
        return $this.nativeGetCharIndexOfSearchResult(searchHandlePtr);
    }

    public static final /* synthetic */ boolean access$nativeSearchPrev(PdfiumCore $this, long searchHandlePtr) {
        return $this.nativeSearchPrev(searchHandlePtr);
    }

    static {
        System.loadLibrary("pdfium");
        System.loadLibrary("pdfium_jni");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/harissk/pdfium/PdfiumCore$Companion;", "", "()V", "TAG", "", "pdfium_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

