/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.fallback;

import io.github.resilience4j.core.functions.CheckedSupplier;
import io.github.resilience4j.fallback.DefaultFallbackDecorator;
import io.github.resilience4j.fallback.FallbackDecorator;
import io.github.resilience4j.fallback.FallbackMethod;
import java.util.List;

public class FallbackDecorators {
    private final List<FallbackDecorator> fallbackDecorators;
    private final FallbackDecorator defaultFallbackDecorator = new DefaultFallbackDecorator();

    public FallbackDecorators(List<FallbackDecorator> fallbackDecorators) {
        this.fallbackDecorators = fallbackDecorators;
    }

    public CheckedSupplier<Object> decorate(FallbackMethod fallbackMethod, CheckedSupplier<Object> supplier) {
        return this.get(fallbackMethod.getReturnType()).decorate(fallbackMethod, supplier);
    }

    private FallbackDecorator get(Class<?> returnType) {
        return this.fallbackDecorators.stream().filter(it -> it.supports(returnType)).findFirst().orElse(this.defaultFallbackDecorator);
    }

    public List<FallbackDecorator> getFallbackDecorators() {
        return this.fallbackDecorators;
    }
}

