/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.springboot3.micrometer.autoconfigure;

import io.github.resilience4j.common.CompositeCustomizer;
import io.github.resilience4j.common.micrometer.configuration.TimerConfigCustomizer;
import io.github.resilience4j.consumer.EventConsumerRegistry;
import io.github.resilience4j.core.registry.RegistryEventConsumer;
import io.github.resilience4j.micrometer.Timer;
import io.github.resilience4j.micrometer.TimerRegistry;
import io.github.resilience4j.micrometer.event.TimerEvent;
import io.github.resilience4j.spring6.fallback.FallbackExecutor;
import io.github.resilience4j.spring6.micrometer.configure.ReactorTimerAspectExt;
import io.github.resilience4j.spring6.micrometer.configure.RxJava2TimerAspectExt;
import io.github.resilience4j.spring6.micrometer.configure.RxJava3TimerAspectExt;
import io.github.resilience4j.spring6.micrometer.configure.TimerAspect;
import io.github.resilience4j.spring6.micrometer.configure.TimerAspectExt;
import io.github.resilience4j.spring6.micrometer.configure.TimerConfiguration;
import io.github.resilience4j.spring6.micrometer.configure.TimerConfigurationProperties;
import io.github.resilience4j.spring6.spelresolver.SpelResolver;
import io.github.resilience4j.spring6.utils.AspectJOnClasspathCondition;
import io.github.resilience4j.spring6.utils.ReactorOnClasspathCondition;
import io.github.resilience4j.spring6.utils.RxJava2OnClasspathCondition;
import io.github.resilience4j.spring6.utils.RxJava3OnClasspathCondition;
import io.github.resilience4j.springboot3.fallback.autoconfigure.FallbackConfigurationOnMissingBean;
import io.github.resilience4j.springboot3.spelresolver.autoconfigure.SpelResolverConfigurationOnMissingBean;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;

@Configuration
@Import(value={FallbackConfigurationOnMissingBean.class, SpelResolverConfigurationOnMissingBean.class})
public abstract class AbstractTimerConfigurationOnMissingBean {
    protected final TimerConfiguration timerConfiguration = new TimerConfiguration();

    protected AbstractTimerConfigurationOnMissingBean() {
    }

    @Bean
    @ConditionalOnMissingBean(name={"compositeTimerCustomizer"})
    @Qualifier(value="compositeTimerCustomizer")
    public CompositeCustomizer<TimerConfigCustomizer> compositeTimerCustomizer(@Autowired(required=false) List<TimerConfigCustomizer> customizers) {
        return new CompositeCustomizer(customizers);
    }

    @Bean
    @ConditionalOnMissingBean
    public TimerRegistry timerRegistry(TimerConfigurationProperties timerProperties, EventConsumerRegistry<TimerEvent> timerEventsConsumerRegistry, RegistryEventConsumer<Timer> timerRegistryEventConsumer, @Qualifier(value="compositeTimerCustomizer") CompositeCustomizer<TimerConfigCustomizer> compositeTimerCustomizer, @Autowired(required=false) MeterRegistry registry) {
        return this.timerConfiguration.timerRegistry(timerProperties, timerEventsConsumerRegistry, timerRegistryEventConsumer, compositeTimerCustomizer, registry);
    }

    @Bean
    @Primary
    public RegistryEventConsumer<Timer> timerRegistryEventConsumer(Optional<List<RegistryEventConsumer<Timer>>> optionalRegistryEventConsumers) {
        return this.timerConfiguration.timerRegistryEventConsumer(optionalRegistryEventConsumers);
    }

    @Bean
    @Conditional(value={AspectJOnClasspathCondition.class})
    @ConditionalOnMissingBean
    public TimerAspect timerAspect(TimerConfigurationProperties timerProperties, TimerRegistry timerRegistry, @Autowired(required=false) List<TimerAspectExt> timerAspectExtList, FallbackExecutor fallbackExecutor, SpelResolver spelResolver) {
        return this.timerConfiguration.timerAspect(timerProperties, timerRegistry, timerAspectExtList, fallbackExecutor, spelResolver);
    }

    @Bean
    @Conditional(value={RxJava2OnClasspathCondition.class, AspectJOnClasspathCondition.class})
    @ConditionalOnMissingBean
    public RxJava2TimerAspectExt rxJava2TimerAspectExt() {
        return this.timerConfiguration.rxJava2TimerAspectExt();
    }

    @Bean
    @Conditional(value={RxJava3OnClasspathCondition.class, AspectJOnClasspathCondition.class})
    @ConditionalOnMissingBean
    public RxJava3TimerAspectExt rxJava3TimerAspectExt() {
        return this.timerConfiguration.rxJava3TimerAspectExt();
    }

    @Bean
    @Conditional(value={ReactorOnClasspathCondition.class, AspectJOnClasspathCondition.class})
    @ConditionalOnMissingBean
    public ReactorTimerAspectExt reactorTimerAspectExt() {
        return this.timerConfiguration.reactorTimerAspectExt();
    }
}

