/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.springboot3.micrometer.monitoring.endpoint;

import io.github.resilience4j.common.micrometer.monitoring.endpoint.TimerEndpointResponse;
import io.github.resilience4j.micrometer.Timer;
import io.github.resilience4j.micrometer.TimerRegistry;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;

@Endpoint(id="timers")
public class TimerEndpoint {
    private final TimerRegistry timerRegistry;

    public TimerEndpoint(TimerRegistry timerRegistry) {
        this.timerRegistry = timerRegistry;
    }

    @ReadOperation
    public TimerEndpointResponse getAllRetries() {
        List retries = this.timerRegistry.getAllTimers().map(Timer::getName).sorted().collect(Collectors.toList());
        return new TimerEndpointResponse(retries);
    }
}

