/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.rxjava3;

import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public abstract class AbstractSubscriber<T>
implements Subscriber<T>,
Subscription,
Disposable {
    protected final Subscriber<? super T> downstreamSubscriber;
    protected final AtomicBoolean eventWasEmitted = new AtomicBoolean(false);
    private final AtomicReference<Subscription> subscription = new AtomicReference();

    protected AbstractSubscriber(Subscriber<? super T> downstreamSubscriber) {
        this.downstreamSubscriber = Objects.requireNonNull(downstreamSubscriber);
    }

    public void onSubscribe(Subscription s) {
        if (SubscriptionHelper.setOnce(this.subscription, (Subscription)s)) {
            this.downstreamSubscriber.onSubscribe((Subscription)this);
        }
    }

    public void onNext(T value) {
        if (!this.isDisposed()) {
            this.hookOnNext(value);
            this.eventWasEmitted.set(true);
            this.downstreamSubscriber.onNext(value);
        }
    }

    protected void hookOnNext(T value) {
    }

    public void onError(Throwable t) {
        if (SubscriptionHelper.cancel(this.subscription)) {
            this.hookOnError(t);
            this.downstreamSubscriber.onError(t);
        }
    }

    protected abstract void hookOnError(Throwable var1);

    public void onComplete() {
        if (SubscriptionHelper.cancel(this.subscription)) {
            this.hookOnComplete();
            this.downstreamSubscriber.onComplete();
        }
    }

    protected abstract void hookOnComplete();

    public void request(long n) {
        SubscriptionHelper.validate((long)n);
        this.subscription.get().request(n);
    }

    public void cancel() {
        if (SubscriptionHelper.cancel(this.subscription)) {
            this.hookOnCancel();
        }
    }

    protected abstract void hookOnCancel();

    public void dispose() {
        this.cancel();
    }

    public boolean isDisposed() {
        return this.subscription.get() == SubscriptionHelper.CANCELLED;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

