/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.rxjava3.bulkhead.operator;

import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadFullException;
import io.github.resilience4j.rxjava3.AbstractMaybeObserver;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.MaybeObserver;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;

class MaybeBulkhead<T>
extends Maybe<T> {
    private final Maybe<T> upstream;
    private final Bulkhead bulkhead;

    MaybeBulkhead(Maybe<T> upstream, Bulkhead bulkhead) {
        this.upstream = upstream;
        this.bulkhead = bulkhead;
    }

    protected void subscribeActual(MaybeObserver<? super T> downstream) {
        if (this.bulkhead.tryAcquirePermission()) {
            this.upstream.subscribe((MaybeObserver)new BulkheadMaybeObserver(downstream));
        } else {
            downstream.onSubscribe((Disposable)EmptyDisposable.INSTANCE);
            downstream.onError((Throwable)BulkheadFullException.createBulkheadFullException((Bulkhead)this.bulkhead));
        }
    }

    class BulkheadMaybeObserver
    extends AbstractMaybeObserver<T> {
        BulkheadMaybeObserver(MaybeObserver<? super T> downstreamObserver) {
            super(downstreamObserver);
        }

        @Override
        protected void hookOnComplete() {
            MaybeBulkhead.this.bulkhead.onComplete();
        }

        @Override
        protected void hookOnError(Throwable e) {
            MaybeBulkhead.this.bulkhead.onComplete();
        }

        @Override
        protected void hookOnSuccess() {
            MaybeBulkhead.this.bulkhead.onComplete();
        }

        @Override
        protected void hookOnCancel() {
            MaybeBulkhead.this.bulkhead.releasePermission();
        }
    }
}

