/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker.operator;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.operator.CompletableCircuitBreaker;
import io.github.resilience4j.circuitbreaker.operator.FlowableCircuitBreaker;
import io.github.resilience4j.circuitbreaker.operator.MaybeCircuitBreaker;
import io.github.resilience4j.circuitbreaker.operator.ObserverCircuitBreaker;
import io.github.resilience4j.circuitbreaker.operator.SingleCircuitBreaker;
import io.reactivex.Completable;
import io.reactivex.CompletableSource;
import io.reactivex.CompletableTransformer;
import io.reactivex.Flowable;
import io.reactivex.FlowableTransformer;
import io.reactivex.Maybe;
import io.reactivex.MaybeSource;
import io.reactivex.MaybeTransformer;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.ObservableTransformer;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.reactivex.SingleTransformer;
import java.util.Objects;
import org.reactivestreams.Publisher;

public class CircuitBreakerOperator<T>
implements FlowableTransformer<T, T>,
SingleTransformer<T, T>,
MaybeTransformer<T, T>,
CompletableTransformer,
ObservableTransformer<T, T> {
    private final CircuitBreaker circuitBreaker;

    private CircuitBreakerOperator(CircuitBreaker circuitBreaker) {
        this.circuitBreaker = Objects.requireNonNull(circuitBreaker);
    }

    public static <T> CircuitBreakerOperator<T> of(CircuitBreaker circuitBreaker) {
        return new CircuitBreakerOperator<T>(circuitBreaker);
    }

    public Publisher<T> apply(Flowable<T> upstream) {
        return new FlowableCircuitBreaker<T>(upstream, this.circuitBreaker);
    }

    public SingleSource<T> apply(Single<T> upstream) {
        return new SingleCircuitBreaker<T>(upstream, this.circuitBreaker);
    }

    public CompletableSource apply(Completable upstream) {
        return new CompletableCircuitBreaker(upstream, this.circuitBreaker);
    }

    public MaybeSource<T> apply(Maybe<T> upstream) {
        return new MaybeCircuitBreaker<T>(upstream, this.circuitBreaker);
    }

    public ObservableSource<T> apply(Observable<T> upstream) {
        return new ObserverCircuitBreaker<T>(upstream, this.circuitBreaker);
    }
}

