/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratelimiter.operator;

import io.github.resilience4j.AbstractSubscriber;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RequestNotPermitted;
import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.internal.subscriptions.EmptySubscription;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

class FlowableRateLimiter<T>
extends Flowable<T> {
    private final RateLimiter rateLimiter;
    private final Publisher<T> upstream;

    FlowableRateLimiter(Publisher<T> upstream, RateLimiter rateLimiter) {
        this.rateLimiter = Objects.requireNonNull(rateLimiter);
        this.upstream = Objects.requireNonNull(upstream, "source is null");
    }

    protected void subscribeActual(Subscriber<? super T> downstream) {
        long waitDuration = this.rateLimiter.reservePermission();
        if (waitDuration >= 0L) {
            if (waitDuration > 0L) {
                Completable.timer((long)waitDuration, (TimeUnit)TimeUnit.NANOSECONDS).subscribe(() -> this.upstream.subscribe((Subscriber)new RateLimiterSubscriber(downstream)));
            } else {
                this.upstream.subscribe((Subscriber)new RateLimiterSubscriber(downstream));
            }
        } else {
            downstream.onSubscribe((Subscription)EmptySubscription.INSTANCE);
            downstream.onError((Throwable)RequestNotPermitted.createRequestNotPermitted((RateLimiter)this.rateLimiter));
        }
    }

    class RateLimiterSubscriber
    extends AbstractSubscriber<T> {
        RateLimiterSubscriber(Subscriber<? super T> downstreamSubscriber) {
            super(downstreamSubscriber);
        }

        @Override
        public void hookOnError(Throwable t) {
        }

        @Override
        public void hookOnComplete() {
        }

        @Override
        public void hookOnCancel() {
        }
    }
}

