/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.bulkhead.operator;

import io.github.resilience4j.AbstractCompletableObserver;
import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadFullException;
import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.EmptyDisposable;

class CompletableBulkhead
extends Completable {
    private final Completable upstream;
    private final Bulkhead bulkhead;

    CompletableBulkhead(Completable upstream, Bulkhead bulkhead) {
        this.upstream = upstream;
        this.bulkhead = bulkhead;
    }

    protected void subscribeActual(CompletableObserver downstream) {
        if (this.bulkhead.tryAcquirePermission()) {
            this.upstream.subscribe((CompletableObserver)new BulkheadCompletableObserver(downstream));
        } else {
            downstream.onSubscribe((Disposable)EmptyDisposable.INSTANCE);
            downstream.onError((Throwable)BulkheadFullException.createBulkheadFullException((Bulkhead)this.bulkhead));
        }
    }

    class BulkheadCompletableObserver
    extends AbstractCompletableObserver {
        BulkheadCompletableObserver(CompletableObserver downstreamObserver) {
            super(downstreamObserver);
        }

        @Override
        protected void hookOnComplete() {
            CompletableBulkhead.this.bulkhead.onComplete();
        }

        @Override
        protected void hookOnError(Throwable e) {
            CompletableBulkhead.this.bulkhead.onComplete();
        }

        @Override
        protected void hookOnCancel() {
            CompletableBulkhead.this.bulkhead.releasePermission();
        }
    }
}

