/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.retry.transformer;

import io.github.resilience4j.retry.Retry;
import io.reactivex.Completable;
import io.reactivex.CompletableSource;
import io.reactivex.CompletableTransformer;
import io.reactivex.Flowable;
import io.reactivex.FlowableTransformer;
import io.reactivex.Maybe;
import io.reactivex.MaybeSource;
import io.reactivex.MaybeTransformer;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.ObservableTransformer;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.reactivex.SingleTransformer;
import org.reactivestreams.Publisher;

public class RetryTransformer<T>
implements FlowableTransformer<T, T>,
ObservableTransformer<T, T>,
SingleTransformer<T, T>,
CompletableTransformer,
MaybeTransformer<T, T> {
    private final Retry retry;

    private RetryTransformer(Retry retry) {
        this.retry = retry;
    }

    public static <T> RetryTransformer<T> of(Retry retry) {
        return new RetryTransformer<T>(retry);
    }

    public Publisher<T> apply(Flowable<T> upstream) {
        Context context = new Context(this.retry.context());
        return upstream.doOnNext(context::throwExceptionToForceRetryOnResult).retryWhen(errors -> errors.doOnNext(context::onError)).doOnComplete(context::onComplete);
    }

    public ObservableSource<T> apply(Observable<T> upstream) {
        Context context = new Context(this.retry.context());
        return upstream.doOnNext(context::throwExceptionToForceRetryOnResult).retryWhen(errors -> errors.doOnNext(context::onError)).doOnComplete(context::onComplete);
    }

    public SingleSource<T> apply(Single<T> upstream) {
        Context context = new Context(this.retry.context());
        return upstream.doOnSuccess(context::throwExceptionToForceRetryOnResult).retryWhen(errors -> errors.doOnNext(context::onError)).doOnSuccess(t -> context.onComplete());
    }

    public CompletableSource apply(Completable upstream) {
        Context context = new Context(this.retry.context());
        return upstream.retryWhen(errors -> errors.doOnNext(context::onError)).doOnComplete(context::onComplete);
    }

    public MaybeSource<T> apply(Maybe<T> upstream) {
        Context context = new Context(this.retry.context());
        return upstream.doOnSuccess(context::throwExceptionToForceRetryOnResult).retryWhen(errors -> errors.doOnNext(context::onError)).doOnSuccess(t -> context.onComplete()).doOnComplete(context::onComplete);
    }

    private static class Context<T> {
        private final Retry.Context<T> context;

        Context(Retry.Context<T> context) {
            this.context = context;
        }

        void onComplete() {
            this.context.onComplete();
        }

        void throwExceptionToForceRetryOnResult(T value) {
            if (this.context.onResult(value)) {
                throw new RetryDueToResultException();
            }
        }

        void onError(Throwable throwable) throws Exception {
            if (throwable instanceof RetryDueToResultException) {
                return;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            try {
                this.context.onError(this.castToException(throwable));
            }
            catch (Throwable t) {
                throw this.castToException(t);
            }
        }

        private Exception castToException(Throwable throwable) {
            return throwable instanceof Exception ? (Exception)throwable : new Exception(throwable);
        }

        private static class RetryDueToResultException
        extends RuntimeException {
            RetryDueToResultException() {
                super("retry due to retryOnResult predicate");
            }
        }
    }
}

