/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratelimiter.operator;

import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.operator.RateLimiterCompletableObserver;
import io.github.resilience4j.ratelimiter.operator.RateLimiterMaybeObserver;
import io.github.resilience4j.ratelimiter.operator.RateLimiterObserver;
import io.github.resilience4j.ratelimiter.operator.RateLimiterSingleObserver;
import io.github.resilience4j.ratelimiter.operator.RateLimiterSubscriber;
import io.reactivex.CompletableObserver;
import io.reactivex.CompletableOperator;
import io.reactivex.FlowableOperator;
import io.reactivex.MaybeObserver;
import io.reactivex.MaybeOperator;
import io.reactivex.ObservableOperator;
import io.reactivex.Observer;
import io.reactivex.SingleObserver;
import io.reactivex.SingleOperator;
import java.util.Objects;
import org.reactivestreams.Subscriber;

public class RateLimiterOperator<T>
implements ObservableOperator<T, T>,
FlowableOperator<T, T>,
SingleOperator<T, T>,
CompletableOperator,
MaybeOperator<T, T> {
    private final RateLimiter rateLimiter;

    private RateLimiterOperator(RateLimiter rateLimiter) {
        this.rateLimiter = Objects.requireNonNull(rateLimiter);
    }

    public static <T> RateLimiterOperator<T> of(RateLimiter rateLimiter) {
        return new RateLimiterOperator<T>(rateLimiter);
    }

    public Subscriber<? super T> apply(Subscriber<? super T> childSubscriber) throws Exception {
        return new RateLimiterSubscriber<T>(this.rateLimiter, childSubscriber);
    }

    public Observer<? super T> apply(Observer<? super T> childObserver) throws Exception {
        return new RateLimiterObserver<T>(this.rateLimiter, childObserver);
    }

    public SingleObserver<? super T> apply(SingleObserver<? super T> childObserver) throws Exception {
        return new RateLimiterSingleObserver<T>(this.rateLimiter, childObserver);
    }

    public CompletableObserver apply(CompletableObserver observer) throws Exception {
        return new RateLimiterCompletableObserver(this.rateLimiter, observer);
    }

    public MaybeObserver<? super T> apply(MaybeObserver<? super T> observer) throws Exception {
        return new RateLimiterMaybeObserver<T>(this.rateLimiter, observer);
    }
}

