/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratelimiter.operator;

import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.operator.DisposableRateLimiter;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

final class RateLimiterObserver<T>
extends DisposableRateLimiter<T>
implements Observer<T> {
    private final Observer<? super T> childObserver;
    private final AtomicBoolean firstEvent = new AtomicBoolean(true);

    RateLimiterObserver(RateLimiter rateLimiter, Observer<? super T> childObserver) {
        super(rateLimiter);
        this.childObserver = Objects.requireNonNull(childObserver);
    }

    public void onSubscribe(Disposable disposable) {
        this.onSubscribeWithPermit(disposable);
    }

    @Override
    protected void onSubscribeInner(Disposable disposable) {
        this.childObserver.onSubscribe(disposable);
    }

    public void onNext(T value) {
        this.onNextInner(value, this.firstEvent.getAndSet(false));
    }

    @Override
    protected void permittedOnNext(T value) {
        this.childObserver.onNext(value);
    }

    public void onComplete() {
        this.onCompleteInner();
    }

    @Override
    protected void permittedOnComplete() {
        this.childObserver.onComplete();
    }

    public void onError(Throwable e) {
        this.onErrorInner(e);
    }

    @Override
    protected void permittedOnError(Throwable e) {
        this.childObserver.onError(e);
    }
}

