/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.common.retry.configuration;

import io.github.resilience4j.common.CommonProperties;
import io.github.resilience4j.common.CompositeCustomizer;
import io.github.resilience4j.common.retry.configuration.RetryConfigCustomizer;
import io.github.resilience4j.common.utils.ConfigUtils;
import io.github.resilience4j.core.ClassUtils;
import io.github.resilience4j.core.ConfigurationNotFoundException;
import io.github.resilience4j.core.IntervalFunction;
import io.github.resilience4j.core.StringUtils;
import io.github.resilience4j.core.lang.Nullable;
import io.github.resilience4j.retry.RetryConfig;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class RetryConfigurationProperties
extends CommonProperties {
    private final Map<String, InstanceProperties> instances = new HashMap<String, InstanceProperties>();
    private Map<String, InstanceProperties> configs = new HashMap<String, InstanceProperties>();

    public RetryConfig createRetryConfig(String backend, CompositeCustomizer<RetryConfigCustomizer> compositeRetryCustomizer) {
        return this.createRetryConfig(this.getBackendProperties(backend), compositeRetryCustomizer, backend);
    }

    @Nullable
    public InstanceProperties getBackendProperties(String backend) {
        return this.instances.get(backend);
    }

    public Map<String, InstanceProperties> getInstances() {
        return this.instances;
    }

    public Map<String, InstanceProperties> getBackends() {
        return this.instances;
    }

    public Map<String, InstanceProperties> getConfigs() {
        return this.configs;
    }

    public RetryConfig createRetryConfig(InstanceProperties instanceProperties, CompositeCustomizer<RetryConfigCustomizer> compositeRetryCustomizer, String backend) {
        if (instanceProperties != null && StringUtils.isNotEmpty((String)instanceProperties.getBaseConfig())) {
            InstanceProperties baseProperties = this.configs.get(instanceProperties.getBaseConfig());
            if (baseProperties == null) {
                throw new ConfigurationNotFoundException(instanceProperties.getBaseConfig());
            }
            return this.buildConfigFromBaseConfig(baseProperties, instanceProperties, compositeRetryCustomizer, backend);
        }
        return this.buildRetryConfig(RetryConfig.custom(), instanceProperties, compositeRetryCustomizer, backend);
    }

    private RetryConfig buildConfigFromBaseConfig(InstanceProperties baseProperties, InstanceProperties instanceProperties, CompositeCustomizer<RetryConfigCustomizer> compositeRetryCustomizer, String backend) {
        RetryConfig baseConfig = this.buildRetryConfig(RetryConfig.custom(), baseProperties, compositeRetryCustomizer, backend);
        ConfigUtils.mergePropertiesIfAny(baseProperties, instanceProperties);
        return this.buildRetryConfig(RetryConfig.from((RetryConfig)baseConfig), instanceProperties, compositeRetryCustomizer, backend);
    }

    private RetryConfig buildRetryConfig(RetryConfig.Builder builder, InstanceProperties properties, CompositeCustomizer<RetryConfigCustomizer> compositeRetryCustomizer, String backend) {
        Predicate predicate;
        if (properties == null) {
            return builder.build();
        }
        this.configureRetryIntervalFunction(properties, (RetryConfig.Builder<Object>)builder);
        if (properties.getMaxRetryAttempts() != null && properties.getMaxRetryAttempts() != 0) {
            builder.maxAttempts(properties.getMaxRetryAttempts().intValue());
        }
        if (properties.getMaxAttempts() != null && properties.getMaxAttempts() != 0) {
            builder.maxAttempts(properties.getMaxAttempts().intValue());
        }
        if (properties.getRetryExceptionPredicate() != null) {
            predicate = ClassUtils.instantiatePredicateClass(properties.getRetryExceptionPredicate());
            builder.retryOnException(predicate);
        }
        if (properties.getIgnoreExceptions() != null) {
            builder.ignoreExceptions((Class[])properties.getIgnoreExceptions());
        }
        if (properties.getRetryExceptions() != null) {
            builder.retryExceptions((Class[])properties.getRetryExceptions());
        }
        if (properties.getResultPredicate() != null) {
            predicate = ClassUtils.instantiatePredicateClass(properties.getResultPredicate());
            builder.retryOnResult(predicate);
        }
        compositeRetryCustomizer.getCustomizer(backend).ifPresent(customizer -> customizer.customize(builder));
        return builder.build();
    }

    private void configureRetryIntervalFunction(InstanceProperties properties, RetryConfig.Builder<Object> builder) {
        if (properties.getWaitDuration() != null && properties.getWaitDuration().toMillis() > 0L) {
            if (Boolean.TRUE.equals(properties.getEnableExponentialBackoff()) && Boolean.TRUE.equals(properties.getEnableRandomizedWait())) {
                this.configureExponentialBackoffAndRandomizedWait(properties, builder);
            } else if (Boolean.TRUE.equals(properties.getEnableExponentialBackoff())) {
                this.configureExponentialBackoff(properties, builder);
            } else if (Boolean.TRUE.equals(properties.getEnableRandomizedWait())) {
                this.configureRandomizedWait(properties, builder);
            } else {
                builder.waitDuration(properties.getWaitDuration());
            }
        }
    }

    private void configureExponentialBackoffAndRandomizedWait(InstanceProperties properties, RetryConfig.Builder<Object> builder) {
        Duration waitDuration = properties.getWaitDuration();
        Double backoffMultiplier = properties.getExponentialBackoffMultiplier();
        Double randomizedWaitFactor = properties.getRandomizedWaitFactor();
        Duration maxWaitDuration = properties.getExponentialMaxWaitDuration();
        if (maxWaitDuration != null && randomizedWaitFactor != null && backoffMultiplier != null) {
            builder.intervalFunction(IntervalFunction.ofExponentialRandomBackoff((Duration)waitDuration, (double)backoffMultiplier, (double)randomizedWaitFactor, (Duration)maxWaitDuration));
        } else if (randomizedWaitFactor != null && backoffMultiplier != null) {
            builder.intervalFunction(IntervalFunction.ofExponentialRandomBackoff((Duration)waitDuration, (double)backoffMultiplier, (double)randomizedWaitFactor));
        } else if (backoffMultiplier != null) {
            builder.intervalFunction(IntervalFunction.ofExponentialRandomBackoff((Duration)waitDuration, (double)backoffMultiplier));
        } else {
            builder.intervalFunction(IntervalFunction.ofExponentialRandomBackoff((Duration)waitDuration));
        }
    }

    private void configureExponentialBackoff(InstanceProperties properties, RetryConfig.Builder<Object> builder) {
        Duration waitDuration = properties.getWaitDuration();
        Double backoffMultiplier = properties.getExponentialBackoffMultiplier();
        Duration maxWaitDuration = properties.getExponentialMaxWaitDuration();
        if (maxWaitDuration != null && backoffMultiplier != null) {
            builder.intervalFunction(IntervalFunction.ofExponentialBackoff((Duration)waitDuration, (double)backoffMultiplier, (Duration)maxWaitDuration));
        } else if (backoffMultiplier != null) {
            builder.intervalFunction(IntervalFunction.ofExponentialBackoff((Duration)waitDuration, (double)backoffMultiplier));
        } else {
            builder.intervalFunction(IntervalFunction.ofExponentialBackoff((Duration)waitDuration));
        }
    }

    private void configureRandomizedWait(InstanceProperties properties, RetryConfig.Builder<Object> builder) {
        Duration waitDuration = properties.getWaitDuration();
        Double randomizedWaitFactor = properties.getRandomizedWaitFactor();
        if (randomizedWaitFactor != null) {
            builder.intervalFunction(IntervalFunction.ofRandomized((Duration)waitDuration, (double)randomizedWaitFactor));
        } else {
            builder.intervalFunction(IntervalFunction.ofRandomized((Duration)waitDuration));
        }
    }

    public static class InstanceProperties {
        @Nullable
        private Duration waitDuration;
        @Nullable
        @Deprecated
        private Integer maxRetryAttempts;
        @Nullable
        private Integer maxAttempts;
        @Nullable
        private Class<? extends Predicate<Throwable>> retryExceptionPredicate;
        @Nullable
        private Class<? extends Predicate<Object>> resultPredicate;
        @Nullable
        private Class<? extends Throwable>[] retryExceptions;
        @Nullable
        private Class<? extends Throwable>[] ignoreExceptions;
        @Nullable
        private Integer eventConsumerBufferSize;
        @Nullable
        private Boolean enableExponentialBackoff;
        private Double exponentialBackoffMultiplier;
        private Duration exponentialMaxWaitDuration;
        @Nullable
        private Boolean enableRandomizedWait;
        private Double randomizedWaitFactor;
        @Nullable
        private String baseConfig;

        @Nullable
        public Duration getWaitDuration() {
            return this.waitDuration;
        }

        public InstanceProperties setWaitDuration(Duration waitDuration) {
            Objects.requireNonNull(waitDuration);
            if (waitDuration.toMillis() < 0L) {
                throw new IllegalArgumentException("waitDuration must be a positive value");
            }
            this.waitDuration = waitDuration;
            return this;
        }

        @Nullable
        @Deprecated
        public Integer getMaxRetryAttempts() {
            return this.maxRetryAttempts;
        }

        @Nullable
        public Integer getMaxAttempts() {
            return this.maxAttempts;
        }

        @Deprecated
        public InstanceProperties setMaxRetryAttempts(Integer maxRetryAttempts) {
            Objects.requireNonNull(maxRetryAttempts);
            if (maxRetryAttempts < 1) {
                throw new IllegalArgumentException("maxRetryAttempts must be greater than or equal to 1.");
            }
            this.maxRetryAttempts = maxRetryAttempts;
            return this;
        }

        public InstanceProperties setMaxAttempts(Integer maxAttempts) {
            Objects.requireNonNull(maxAttempts);
            if (maxAttempts < 1) {
                throw new IllegalArgumentException("maxAttempts must be greater than or equal to 1.");
            }
            this.maxAttempts = maxAttempts;
            return this;
        }

        @Nullable
        public Class<? extends Predicate<Throwable>> getRetryExceptionPredicate() {
            return this.retryExceptionPredicate;
        }

        public InstanceProperties setRetryExceptionPredicate(Class<? extends Predicate<Throwable>> retryExceptionPredicate) {
            this.retryExceptionPredicate = retryExceptionPredicate;
            return this;
        }

        @Nullable
        public Class<? extends Predicate<Object>> getResultPredicate() {
            return this.resultPredicate;
        }

        public InstanceProperties setResultPredicate(Class<? extends Predicate<Object>> resultPredicate) {
            this.resultPredicate = resultPredicate;
            return this;
        }

        @Nullable
        public Class<? extends Throwable>[] getRetryExceptions() {
            return this.retryExceptions;
        }

        public InstanceProperties setRetryExceptions(Class<? extends Throwable>[] retryExceptions) {
            this.retryExceptions = retryExceptions;
            return this;
        }

        @Nullable
        public Class<? extends Throwable>[] getIgnoreExceptions() {
            return this.ignoreExceptions;
        }

        public InstanceProperties setIgnoreExceptions(Class<? extends Throwable>[] ignoreExceptions) {
            this.ignoreExceptions = ignoreExceptions;
            return this;
        }

        public Integer getEventConsumerBufferSize() {
            return this.eventConsumerBufferSize;
        }

        public InstanceProperties setEventConsumerBufferSize(Integer eventConsumerBufferSize) {
            Objects.requireNonNull(eventConsumerBufferSize);
            if (eventConsumerBufferSize < 1) {
                throw new IllegalArgumentException("eventConsumerBufferSize must be greater than or equal to 1.");
            }
            this.eventConsumerBufferSize = eventConsumerBufferSize;
            return this;
        }

        public Boolean getEnableExponentialBackoff() {
            return this.enableExponentialBackoff;
        }

        public InstanceProperties setEnableExponentialBackoff(Boolean enableExponentialBackoff) {
            this.enableExponentialBackoff = enableExponentialBackoff;
            return this;
        }

        @Nullable
        public Double getExponentialBackoffMultiplier() {
            return this.exponentialBackoffMultiplier;
        }

        public InstanceProperties setExponentialBackoffMultiplier(Double exponentialBackoffMultiplier) {
            this.exponentialBackoffMultiplier = exponentialBackoffMultiplier;
            return this;
        }

        @Nullable
        public Duration getExponentialMaxWaitDuration() {
            return this.exponentialMaxWaitDuration;
        }

        public InstanceProperties setExponentialMaxWaitDuration(Duration exponentialMaxWaitDuration) {
            this.exponentialMaxWaitDuration = exponentialMaxWaitDuration;
            return this;
        }

        @Nullable
        public Boolean getEnableRandomizedWait() {
            return this.enableRandomizedWait;
        }

        public InstanceProperties setEnableRandomizedWait(Boolean enableRandomizedWait) {
            this.enableRandomizedWait = enableRandomizedWait;
            return this;
        }

        @Nullable
        public Double getRandomizedWaitFactor() {
            return this.randomizedWaitFactor;
        }

        public InstanceProperties setRandomizedWaitFactor(Double randomizedWaitFactor) {
            this.randomizedWaitFactor = randomizedWaitFactor;
            return this;
        }

        @Nullable
        public String getBaseConfig() {
            return this.baseConfig;
        }

        public InstanceProperties setBaseConfig(String baseConfig) {
            this.baseConfig = baseConfig;
            return this;
        }
    }
}

