/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.common.bulkhead.configuration;

import io.github.resilience4j.bulkhead.BulkheadConfig;
import io.github.resilience4j.common.utils.ConfigUtils;
import io.github.resilience4j.core.ConfigurationNotFoundException;
import io.github.resilience4j.core.StringUtils;
import io.github.resilience4j.core.lang.Nullable;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.Min;
import org.hibernate.validator.constraints.time.DurationMin;

public class BulkheadConfigurationProperties {
    private Map<String, InstanceProperties> instances = new HashMap<String, InstanceProperties>();
    private Map<String, InstanceProperties> configs = new HashMap<String, InstanceProperties>();

    public BulkheadConfig createBulkheadConfig(InstanceProperties instanceProperties) {
        if (StringUtils.isNotEmpty((String)instanceProperties.getBaseConfig())) {
            InstanceProperties baseProperties = this.configs.get(instanceProperties.getBaseConfig());
            if (baseProperties == null) {
                throw new ConfigurationNotFoundException(instanceProperties.getBaseConfig());
            }
            return this.buildConfigFromBaseConfig(baseProperties, instanceProperties);
        }
        return this.buildBulkheadConfig(BulkheadConfig.custom(), instanceProperties);
    }

    private BulkheadConfig buildConfigFromBaseConfig(InstanceProperties baseProperties, InstanceProperties instanceProperties) {
        ConfigUtils.mergePropertiesIfAny(baseProperties, instanceProperties);
        BulkheadConfig baseConfig = this.buildBulkheadConfig(BulkheadConfig.custom(), baseProperties);
        return this.buildBulkheadConfig(BulkheadConfig.from((BulkheadConfig)baseConfig), instanceProperties);
    }

    private BulkheadConfig buildBulkheadConfig(BulkheadConfig.Builder builder, InstanceProperties instanceProperties) {
        if (instanceProperties.getMaxConcurrentCalls() != null) {
            builder.maxConcurrentCalls(instanceProperties.getMaxConcurrentCalls().intValue());
        }
        if (instanceProperties.getMaxWaitDuration() != null) {
            builder.maxWaitDuration(instanceProperties.getMaxWaitDuration());
        }
        return builder.build();
    }

    @Nullable
    public InstanceProperties getBackendProperties(String backend) {
        return this.instances.get(backend);
    }

    public Map<String, InstanceProperties> getInstances() {
        return this.instances;
    }

    public Map<String, InstanceProperties> getBackends() {
        return this.instances;
    }

    public Map<String, InstanceProperties> getConfigs() {
        return this.configs;
    }

    public static class InstanceProperties {
        @Min(value=1L)
        private @Min(value=1L) Integer maxConcurrentCalls;
        @DurationMin(millis=0L)
        private @DurationMin(millis=0L) Duration maxWaitDuration;
        @Nullable
        private String baseConfig;
        @Min(value=1L)
        @Nullable
        private @Min(value=1L) Integer eventConsumerBufferSize;

        public InstanceProperties setMaxConcurrentCalls(Integer maxConcurrentCalls) {
            this.maxConcurrentCalls = maxConcurrentCalls;
            return this;
        }

        public InstanceProperties setMaxWaitDuration(Duration maxWaitDuration) {
            this.maxWaitDuration = maxWaitDuration;
            return this;
        }

        public InstanceProperties setBaseConfig(String baseConfig) {
            this.baseConfig = baseConfig;
            return this;
        }

        public InstanceProperties setEventConsumerBufferSize(Integer eventConsumerBufferSize) {
            this.eventConsumerBufferSize = eventConsumerBufferSize;
            return this;
        }

        public Integer getMaxConcurrentCalls() {
            return this.maxConcurrentCalls;
        }

        public Duration getMaxWaitDuration() {
            return this.maxWaitDuration;
        }

        public String getBaseConfig() {
            return this.baseConfig;
        }

        public Integer getEventConsumerBufferSize() {
            return this.eventConsumerBufferSize;
        }
    }
}

