/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circularbuffer;

import io.github.resilience4j.circularbuffer.CircularFifoBuffer;
import io.github.resilience4j.circularbuffer.ConcurrentEvictingQueue;
import io.vavr.collection.List;
import io.vavr.control.Option;
import java.util.Arrays;

public class ConcurrentCircularFifoBuffer<T>
implements CircularFifoBuffer<T> {
    private final ConcurrentEvictingQueue<T> queue;
    private final int capacity;

    public ConcurrentCircularFifoBuffer(int capacity) {
        this.capacity = capacity;
        this.queue = new ConcurrentEvictingQueue(capacity);
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public boolean isFull() {
        return this.queue.size() == this.capacity;
    }

    @Override
    public List<T> toList() {
        Object[] elementsArray = this.queue.toArray();
        return List.ofAll(Arrays.asList(elementsArray));
    }

    @Override
    public void add(T element) {
        this.queue.offer(element);
    }

    @Override
    public Option<T> take() {
        return Option.of(this.queue.poll());
    }
}

